/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RegExpImpl;

public class NativeRegExpCtor
extends NativeFunction {
    private static final int Id_multiline = 1;
    private static final int Id_STAR = 2;
    private static final int Id_input = 3;
    private static final int Id_UNDERSCORE = 4;
    private static final int Id_lastMatch = 5;
    private static final int Id_AMPERSAND = 6;
    private static final int Id_lastParen = 7;
    private static final int Id_PLUS = 8;
    private static final int Id_leftContext = 9;
    private static final int Id_BACK_QUOTE = 10;
    private static final int Id_rightContext = 11;
    private static final int Id_QUOTE = 12;
    private static final int DOLLAR_ID_BASE = 12;
    private static final int Id_DOLLAR_1 = 13;
    private static final int Id_DOLLAR_2 = 14;
    private static final int Id_DOLLAR_3 = 15;
    private static final int Id_DOLLAR_4 = 16;
    private static final int Id_DOLLAR_5 = 17;
    private static final int Id_DOLLAR_6 = 18;
    private static final int Id_DOLLAR_7 = 19;
    private static final int Id_DOLLAR_8 = 20;
    private static final int Id_DOLLAR_9 = 21;
    private static final int MAX_INSTANCE_ID = 21;
    private static int idBase;

    public NativeRegExpCtor() {
        this.functionName = "RegExp";
    }

    public String getClassName() {
        return "Function";
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp && (objectArray.length == 1 || objectArray[1] == Undefined.instance)) {
            return objectArray[0];
        }
        return this.construct(context, this.parent, objectArray);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.compile(context, scriptable, objectArray);
        nativeRegExp.setPrototype(ScriptableObject.getClassPrototype(scriptable, "RegExp"));
        nativeRegExp.setParentScope(this.getParentScope());
        return nativeRegExp;
    }

    static RegExpImpl getImpl() {
        Context context = Context.getCurrentContext();
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    protected int getIdDefaultAttributes(int n) {
        int n2 = n - idBase;
        if (1 <= n2 && n2 <= 21) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return 4;
                }
            }
            return 5;
        }
        return super.getIdDefaultAttributes(n);
    }

    private static String stringResult(Object object) {
        return object == null ? "" : object.toString();
    }

    protected Object getIdValue(int n) {
        int n2 = n - idBase;
        if (1 <= n2 && n2 <= 21) {
            RegExpImpl regExpImpl = NativeRegExpCtor.getImpl();
            switch (n2) {
                case 1: 
                case 2: {
                    return this.wrap_boolean(regExpImpl.multiline);
                }
                case 3: 
                case 4: {
                    return NativeRegExpCtor.stringResult(regExpImpl.input);
                }
                case 5: 
                case 6: {
                    return NativeRegExpCtor.stringResult(regExpImpl.lastMatch);
                }
                case 7: 
                case 8: {
                    return NativeRegExpCtor.stringResult(regExpImpl.lastParen);
                }
                case 9: 
                case 10: {
                    return NativeRegExpCtor.stringResult(regExpImpl.leftContext);
                }
                case 11: 
                case 12: {
                    return NativeRegExpCtor.stringResult(regExpImpl.rightContext);
                }
            }
            int n3 = n2 - 12 - 1;
            return regExpImpl.getParenSubString(n3).toString();
        }
        return super.getIdValue(n);
    }

    protected void setIdValue(int n, Object object) {
        switch (n - idBase) {
            case 1: 
            case 2: {
                NativeRegExpCtor.getImpl().multiline = ScriptRuntime.toBoolean(object);
                return;
            }
            case 3: 
            case 4: {
                NativeRegExpCtor.getImpl().input = ScriptRuntime.toString(object);
                return;
            }
        }
        super.setIdValue(n, object);
    }

    protected String getIdName(int n) {
        int n2 = n - idBase;
        if (1 <= n2 && n2 <= 21) {
            switch (n2) {
                case 1: {
                    return "multiline";
                }
                case 2: {
                    return "$*";
                }
                case 3: {
                    return "input";
                }
                case 4: {
                    return "$_";
                }
                case 5: {
                    return "lastMatch";
                }
                case 6: {
                    return "$&";
                }
                case 7: {
                    return "lastParen";
                }
                case 8: {
                    return "$+";
                }
                case 9: {
                    return "leftContext";
                }
                case 10: {
                    return "$`";
                }
                case 11: {
                    return "rightContext";
                }
                case 12: {
                    return "$'";
                }
            }
            int n3 = n2 - 12 - 1;
            char[] cArray = new char[]{'$', (char)(49 + n3)};
            return new String(cArray);
        }
        return super.getIdName(n);
    }

    protected int maxInstanceId() {
        if (idBase == 0) {
            idBase = super.maxInstanceId();
        }
        return idBase + 21;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int mapNameToId(String string) {
        int n;
        int n2;
        block28: {
            n2 = 0;
            String string2 = null;
            switch (string.length()) {
                case 2: {
                    switch (string.charAt(1)) {
                        case '&': {
                            if (string.charAt(0) != '$') break;
                            n2 = 6;
                            break block28;
                        }
                        case '\'': {
                            if (string.charAt(0) != '$') break;
                            n2 = 12;
                            break block28;
                        }
                        case '*': {
                            if (string.charAt(0) != '$') break;
                            n2 = 2;
                            break block28;
                        }
                        case '+': {
                            if (string.charAt(0) != '$') break;
                            n2 = 8;
                            break block28;
                        }
                        case '1': {
                            if (string.charAt(0) != '$') break;
                            n2 = 13;
                            break block28;
                        }
                        case '2': {
                            if (string.charAt(0) != '$') break;
                            n2 = 14;
                            break block28;
                        }
                        case '3': {
                            if (string.charAt(0) != '$') break;
                            n2 = 15;
                            break block28;
                        }
                        case '4': {
                            if (string.charAt(0) != '$') break;
                            n2 = 16;
                            break block28;
                        }
                        case '5': {
                            if (string.charAt(0) != '$') break;
                            n2 = 17;
                            break block28;
                        }
                        case '6': {
                            if (string.charAt(0) != '$') break;
                            n2 = 18;
                            break block28;
                        }
                        case '7': {
                            if (string.charAt(0) != '$') break;
                            n2 = 19;
                            break block28;
                        }
                        case '8': {
                            if (string.charAt(0) != '$') break;
                            n2 = 20;
                            break block28;
                        }
                        case '9': {
                            if (string.charAt(0) != '$') break;
                            n2 = 21;
                            break block28;
                        }
                        case '_': {
                            if (string.charAt(0) != '$') break;
                            n2 = 4;
                            break block28;
                        }
                        case '`': {
                            if (string.charAt(0) != '$') break;
                            n2 = 10;
                            break block28;
                        }
                    }
                    break;
                }
                case 5: {
                    string2 = "input";
                    n2 = 3;
                    break;
                }
                case 9: {
                    char c = string.charAt(4);
                    if (c == 'M') {
                        string2 = "lastMatch";
                        n2 = 5;
                        break;
                    }
                    if (c == 'P') {
                        string2 = "lastParen";
                        n2 = 7;
                        break;
                    }
                    if (c != 'i') break;
                    string2 = "multiline";
                    n2 = 1;
                    break;
                }
                case 11: {
                    string2 = "leftContext";
                    n2 = 9;
                    break;
                }
                case 12: {
                    string2 = "rightContext";
                    n2 = 11;
                }
            }
            if (string2 != null && string2 != string && !string2.equals(string)) {
                n2 = 0;
            }
        }
        if (n2 != 0) {
            n = idBase + n2;
            return n;
        }
        n = super.mapNameToId(string);
        return n;
    }
}

