/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.GreedyState;
import org.mozilla.javascript.regexp.MatchState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptable
implements Function {
    public static final int GLOB = 1;
    public static final int FOLD = 2;
    public static final int MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    static final int JS_BITS_PER_BYTE = 8;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_CCLASS = 13;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_DOTSTAR = 24;
    private static final byte REOP_ANCHOR = 25;
    private static final byte REOP_EOLONLY = 26;
    private static final byte REOP_UCFLAT = 27;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_UCCLASS = 29;
    private static final byte REOP_NUCCLASS = 30;
    private static final byte REOP_BACKREFi = 31;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLATi = 34;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ANCHOR1 = 36;
    private static final byte REOP_NCCLASS = 37;
    private static final byte REOP_DOTSTARMIN = 38;
    private static final byte REOP_LPARENNON = 39;
    private static final byte REOP_RPARENNON = 40;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_END = 43;
    private static final int REOP_FLATLEN_MAX = 255;
    private static int level;
    private static String[] reopname;
    static final String metachars = "|^${*+?().[\\";
    static final String closurechars = "{*+?";
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 6;
    private static final int Id_toString = 7;
    private static final int Id_exec = 8;
    private static final int Id_test = 9;
    private static final int Id_prefix = 10;
    private static final int MAX_PROTOTYPE_ID = 10;
    private boolean prototypeFlag;
    private String source;
    private int lastIndex;
    private int parenCount;
    private byte flags;
    private byte[] program;
    RENode ren;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.prototypeFlag = true;
        nativeRegExp.activateIdMap(10);
        nativeRegExp.setSealFunctionsFlag(bl);
        nativeRegExp.setFunctionParametrs(context);
        nativeRegExp.setParentScope(scriptable);
        nativeRegExp.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        NativeRegExpCtor nativeRegExpCtor = new NativeRegExpCtor();
        nativeRegExpCtor.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        nativeRegExpCtor.setParentScope(scriptable);
        nativeRegExpCtor.setImmunePrototypeProperty(nativeRegExp);
        if (bl) {
            nativeRegExp.sealObject();
            nativeRegExpCtor.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "RegExp", nativeRegExpCtor, 2);
    }

    public NativeRegExp(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        this.init(context, scriptable, string, string2, bl);
    }

    public void init(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        int n;
        this.source = string;
        this.flags = 0;
        if (string2 != null) {
            int n2 = 0;
            while (n2 < string2.length()) {
                n = string2.charAt(n2);
                if (n == 103) {
                    this.flags = (byte)(this.flags | 1);
                } else if (n == 105) {
                    this.flags = (byte)(this.flags | 2);
                } else if (n == 109) {
                    this.flags = (byte)(this.flags | 4);
                } else {
                    Object[] objectArray = new Object[]{new Character((char)n)};
                    throw NativeGlobal.constructError(context, "SyntaxError", ScriptRuntime.getMessage("msg.invalid.re.flag", objectArray), scriptable);
                }
                ++n2;
            }
        }
        CompilerState compilerState = new CompilerState(string, this.flags, context, scriptable);
        if (bl) {
            this.ren = null;
            n = string.length();
            int n3 = 0;
            while (n > 0) {
                int n4 = n;
                if (n4 > 255) {
                    n4 = 255;
                }
                RENode rENode = new RENode(compilerState, n4 == 1 ? (byte)22 : 21, new Integer(n3));
                rENode.flags = (byte)4;
                if (n4 > 1) {
                    rENode.kid2 = n3 + n4;
                } else {
                    rENode.flags = (byte)(rENode.flags | 2);
                    rENode.chr = compilerState.source[n3];
                }
                n3 += n4;
                n -= n4;
                if (this.ren == null) {
                    this.ren = rENode;
                    continue;
                }
                this.setNext(compilerState, this.ren, rENode);
            }
        } else {
            this.ren = this.parseRegExp(compilerState);
        }
        if (this.ren == null) {
            return;
        }
        RENode rENode = new RENode(compilerState, 43, null);
        this.setNext(compilerState, this.ren, rENode);
        this.lastIndex = 0;
        this.parenCount = compilerState.parenCount;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        this.setPrototype(ScriptableObject.getClassPrototype(scriptable, "RegExp"));
        this.setParentScope(scriptable);
    }

    public String getClassName() {
        return "RegExp";
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        return (Scriptable)this.call(context, scriptable, null, objectArray);
    }

    Scriptable compile(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp) {
            if (objectArray.length > 1 && objectArray[1] != Undefined.instance) {
                throw NativeGlobal.constructError(context, "TypeError", "only one argument may be specified if the first argument is a RegExp object", scriptable);
            }
            NativeRegExp nativeRegExp = (NativeRegExp)objectArray[0];
            this.source = nativeRegExp.source;
            this.lastIndex = nativeRegExp.lastIndex;
            this.parenCount = nativeRegExp.parenCount;
            this.flags = nativeRegExp.flags;
            this.program = nativeRegExp.program;
            this.ren = nativeRegExp.ren;
            return this;
        }
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        String string2 = objectArray.length > 1 && objectArray[1] != Undefined.instance ? ScriptRuntime.toString(objectArray[1]) : null;
        this.init(context, scriptable, string, string2, false);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/');
        stringBuffer.append(this.source);
        stringBuffer.append('/');
        if ((this.flags & 1) != 0) {
            stringBuffer.append('g');
        }
        if ((this.flags & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((this.flags & 4) != 0) {
            stringBuffer.append('m');
        }
        return stringBuffer.toString();
    }

    public NativeRegExp() {
    }

    private static RegExpImpl getImpl(Context context) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    private Object execSub(Context context, Scriptable scriptable, Object[] objectArray, int n) {
        String string;
        RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
        if (objectArray.length == 0) {
            string = regExpImpl.input;
            if (string == null) {
                Object[] objectArray2 = new Object[]{this.toString()};
                throw NativeGlobal.constructError(context, "SyntaxError", ScriptRuntime.getMessage("msg.no.re.input.for", objectArray2), scriptable);
            }
        } else {
            string = ScriptRuntime.toString(objectArray[0]);
        }
        int n2 = (this.flags & 1) != 0 ? this.lastIndex : 0;
        int[] nArray = new int[]{n2};
        Object object = this.executeRegExp(context, scriptable, regExpImpl, string, nArray, n);
        if ((this.flags & 1) != 0) {
            this.lastIndex = object == null || object == Undefined.instance ? 0 : nArray[0];
        }
        return object;
    }

    private Object exec(Context context, Scriptable scriptable, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    private Object test(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object = this.execSub(context, scriptable, objectArray, 0);
        if (object == null || !object.equals(Boolean.TRUE)) {
            object = Boolean.FALSE;
        }
        return object;
    }

    private Object prefix(Context context, Scriptable scriptable, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 2);
    }

    private String getPrintableString(String string) {
        return "";
    }

    private void dumpRegExp(CompilerState compilerState, RENode rENode) {
    }

    private void fixNext(CompilerState compilerState, RENode rENode, RENode rENode2, RENode rENode3) {
        RENode rENode4;
        boolean bl = rENode2 != null && (rENode2.flags & 8) == 0;
        while ((rENode4 = rENode.next) != null && rENode4 != rENode3) {
            if (rENode.op == 1) {
                RENode rENode5 = (RENode)rENode.kid;
                if (rENode5.op != 23) {
                    RENode rENode6 = rENode5;
                    while (rENode6.next != null) {
                        if (rENode6.op == 1) {
                            throw new RuntimeException("REOP_ALT not expected");
                        }
                        rENode6 = rENode6.next;
                    }
                    rENode6.next = new RENode(compilerState, 23, null);
                    rENode6.next.flags = (byte)(rENode6.next.flags | 8);
                    rENode6.flags = (byte)(rENode6.flags | 0x10);
                    this.fixNext(compilerState, rENode5, rENode2, rENode3);
                }
            }
            rENode = rENode4;
        }
        if (rENode2 != null) {
            rENode2.flags = (rENode2.flags & 8) == 0 ? (byte)(rENode2.flags | 8) : (byte)(rENode2.flags | 0x20);
        }
        rENode.next = rENode2;
        if (bl) {
            rENode.flags = (byte)(rENode.flags | 0x10);
        }
        switch (rENode.op) {
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 39: 
            case 41: 
            case 42: {
                this.fixNext(compilerState, (RENode)rENode.kid, rENode2, rENode3);
                break;
            }
        }
    }

    private void setNext(CompilerState compilerState, RENode rENode, RENode rENode2) {
        this.fixNext(compilerState, rENode, rENode2, null);
    }

    private RENode parseRegExp(CompilerState compilerState) {
        RENode rENode = this.parseAltern(compilerState);
        if (rENode == null) {
            return null;
        }
        int n = compilerState.index;
        char[] cArray = compilerState.source;
        if (n < cArray.length && cArray[n] == '|') {
            RENode rENode2 = rENode;
            if ((rENode = new RENode(compilerState, 1, rENode2)) == null) {
                return null;
            }
            rENode.flags = (byte)(rENode2.flags & 5);
            RENode rENode3 = rENode;
            do {
                compilerState.index = ++n;
                if (n < cArray.length && (cArray[n] == '|' || cArray[n] == ')')) {
                    rENode2 = new RENode(compilerState, 0, null);
                } else {
                    rENode2 = this.parseAltern(compilerState);
                    n = compilerState.index;
                }
                if (rENode2 == null) {
                    return null;
                }
                RENode rENode4 = new RENode(compilerState, 1, rENode2);
                if (rENode4 == null) {
                    return null;
                }
                rENode3.next = rENode4;
                rENode3.flags = (byte)(rENode3.flags | 0x10);
                rENode4.flags = (byte)(rENode2.flags & 5 | 8);
                rENode3 = rENode4;
            } while (n < cArray.length && cArray[n] == '|');
        }
        return rENode;
    }

    private RENode parseAltern(CompilerState compilerState) {
        char c;
        RENode rENode = this.parseItem(compilerState);
        if (rENode == null) {
            return null;
        }
        RENode rENode2 = rENode;
        int n = 0;
        char[] cArray = compilerState.source;
        int n2 = compilerState.index;
        while (n2 != cArray.length && (c = cArray[n2]) != '|' && c != ')') {
            RENode rENode3 = this.parseItem(compilerState);
            if (rENode3 == null) {
                return null;
            }
            this.setNext(compilerState, rENode2, rENode3);
            n |= rENode3.flags;
            rENode2 = rENode3;
            n2 = compilerState.index;
        }
        rENode.flags = (byte)(rENode.flags | n & 4);
        return rENode;
    }

    RENode parseItem(CompilerState compilerState) {
        int n = compilerState.index;
        char[] cArray = compilerState.source;
        switch (n < cArray.length ? cArray[n] : 0) {
            case 94: {
                compilerState.index = n + 1;
                RENode rENode = new RENode(compilerState, 2, null);
                rENode.flags = (byte)(rENode.flags | 1);
                return rENode;
            }
            case 36: {
                compilerState.index = n + 1;
                return new RENode(compilerState, (byte)(n == compilerState.indexBegin || (cArray[n - 1] == '(' || cArray[n - 1] == '|') && (n - 1 == compilerState.indexBegin || cArray[n - 2] != '\\') ? 26 : 3), null);
            }
            case 92: {
                byte by;
                switch (++n < cArray.length ? cArray[n] : 0) {
                    case 98: {
                        by = 4;
                        break;
                    }
                    case 66: {
                        by = 5;
                        break;
                    }
                    default: {
                        return this.parseQuantAtom(compilerState);
                    }
                }
                compilerState.index = n + 1;
                RENode rENode = new RENode(compilerState, by, null);
                rENode.flags = (byte)(rENode.flags | 4);
                return rENode;
            }
        }
        return this.parseQuantAtom(compilerState);
    }

    RENode parseQuantAtom(CompilerState compilerState) {
        RENode rENode = this.parseAtom(compilerState);
        if (rENode == null) {
            return null;
        }
        char[] cArray = compilerState.source;
        int n = compilerState.index;
        block6: while (n < cArray.length) {
            switch (cArray[n]) {
                case '{': {
                    int n2;
                    char c;
                    if (++n == cArray.length || !NativeRegExp.isDigit(c = cArray[n])) {
                        this.reportError("msg.bad.quant", String.valueOf(cArray[compilerState.index]), compilerState);
                        return null;
                    }
                    int n3 = NativeRegExp.unDigit(c);
                    while (++n < cArray.length && NativeRegExp.isDigit(c = cArray[n])) {
                        if ((n3 = 10 * n3 + NativeRegExp.unDigit(c)) >> 16 == 0) continue;
                        this.reportError("msg.overlarge.max", this.tail(cArray, n), compilerState);
                        return null;
                    }
                    if (cArray[n] == ',') {
                        int n4 = ++n;
                        if (NativeRegExp.isDigit(cArray[n])) {
                            n2 = NativeRegExp.unDigit(cArray[n]);
                            while (NativeRegExp.isDigit(c = cArray[++n])) {
                                if ((n2 = 10 * n2 + NativeRegExp.unDigit(c)) >> 16 == 0) continue;
                                this.reportError("msg.overlarge.max", String.valueOf(cArray[n4]), compilerState);
                                return null;
                            }
                            if (n2 == 0) {
                                this.reportError("msg.zero.quant", this.tail(cArray, compilerState.index), compilerState);
                                return null;
                            }
                            if (n3 > n2) {
                                this.reportError("msg.max.lt.min", this.tail(cArray, n4), compilerState);
                                return null;
                            }
                        } else {
                            n2 = 0;
                        }
                    } else {
                        if (n3 == 0) {
                            this.reportError("msg.zero.quant", this.tail(cArray, compilerState.index), compilerState);
                            return null;
                        }
                        n2 = n3;
                    }
                    if (cArray[n] != '}') {
                        this.reportError("msg.unterm.quant", String.valueOf(cArray[compilerState.index]), compilerState);
                        return null;
                    }
                    ++n;
                    RENode rENode2 = new RENode(compilerState, 6, rENode);
                    if (n3 > 0 && (rENode.flags & 4) != 0) {
                        rENode2.flags = (byte)(rENode2.flags | 4);
                    }
                    rENode2.min = (short)n3;
                    rENode2.max = (short)n2;
                    rENode = rENode2;
                    break;
                }
                case '*': {
                    ++n;
                    rENode = new RENode(compilerState, 7, rENode);
                    break;
                }
                case '+': {
                    ++n;
                    RENode rENode2 = new RENode(compilerState, 8, rENode);
                    if ((rENode.flags & 4) != 0) {
                        rENode2.flags = (byte)(rENode2.flags | 4);
                    }
                    rENode = rENode2;
                    break;
                }
                case '?': {
                    ++n;
                    rENode = new RENode(compilerState, 9, rENode);
                    break;
                }
                default: {
                    break block6;
                }
            }
            if (n >= cArray.length || cArray[n] != '?') continue;
            rENode.flags = (byte)(rENode.flags | 0x80);
            ++n;
        }
        compilerState.index = n;
        return rENode;
    }

    RENode parseAtom(CompilerState compilerState) {
        int n;
        int n2 = 0;
        RENode rENode = null;
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = compilerState.source;
        int n3 = n = compilerState.index;
        if (n == cArray.length) {
            compilerState.index = n;
            return new RENode(compilerState, 0, null);
        }
        switch (cArray[n]) {
            case '|': {
                return new RENode(compilerState, 0, null);
            }
            case '(': {
                RENode rENode2;
                byte by = 43;
                if (cArray[n + 1] == '?') {
                    switch (cArray[n + 2]) {
                        case ':': {
                            by = 39;
                            break;
                        }
                        case '=': {
                            by = 41;
                            break;
                        }
                        case '!': {
                            by = 42;
                        }
                    }
                }
                if (by == 43) {
                    by = 10;
                    n2 = compilerState.parenCount++;
                    ++n;
                } else {
                    n += 3;
                }
                compilerState.index = n;
                if (cArray[n] == ')') {
                    rENode2 = new RENode(compilerState, 0, null);
                } else {
                    rENode2 = this.parseRegExp(compilerState);
                    if (rENode2 == null) {
                        return null;
                    }
                    n = compilerState.index;
                    if (n >= cArray.length || cArray[n] != ')') {
                        this.reportError("msg.unterm.paren", this.tail(cArray, n3), compilerState);
                        return null;
                    }
                }
                ++n;
                rENode = new RENode(compilerState, by, rENode2);
                rENode.flags = (byte)(rENode2.flags & 5);
                rENode.num = n2;
                if (by != 10 && by != 39) break;
                rENode2 = new RENode(compilerState, (byte)(by + 1), null);
                this.setNext(compilerState, rENode, rENode2);
                rENode2.num = n2;
                break;
            }
            case '.': {
                int n4 = 12;
                if (++n < cArray.length && cArray[n] == '*') {
                    n4 = 24;
                    if (++n < cArray.length && cArray[n] == '?') {
                        ++n;
                        n4 = 38;
                    }
                }
                rENode = new RENode(compilerState, (byte)n4, null);
                if (rENode.op != 12) break;
                rENode.flags = (byte)6;
                break;
            }
            case '[': {
                if (++n == cArray.length) {
                    this.reportError("msg.unterm.class", this.tail(cArray, n3), compilerState);
                    return null;
                }
                char c = cArray[n];
                rENode = new RENode(compilerState, 13, new Integer(n));
                if (c == '^' && ++n == cArray.length) {
                    this.reportError("msg.unterm.class", this.tail(cArray, n3), compilerState);
                    return null;
                }
                while (true) {
                    if (++n == cArray.length) {
                        this.reportError("msg.unterm.paren", this.tail(cArray, n3), compilerState);
                        return null;
                    }
                    c = cArray[n];
                    if (c == ']') break;
                    if (c != '\\' || n + 1 == cArray.length) continue;
                    ++n;
                }
                rENode.kid2 = n++;
                rENode.flags = (byte)6;
                break;
            }
            case '\\': {
                int n5;
                if (++n == cArray.length) {
                    Context.reportError(ScriptRuntime.getMessage("msg.trail.backslash", null));
                    return null;
                }
                char c = cArray[n];
                switch (c) {
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'v': {
                        c = NativeRegExp.getEscape(c);
                        rENode = new RENode(compilerState, 22, null);
                        break;
                    }
                    case 'd': {
                        rENode = new RENode(compilerState, 14, null);
                        break;
                    }
                    case 'D': {
                        rENode = new RENode(compilerState, 15, null);
                        break;
                    }
                    case 'w': {
                        rENode = new RENode(compilerState, 16, null);
                        break;
                    }
                    case 'W': {
                        rENode = new RENode(compilerState, 17, null);
                        break;
                    }
                    case 's': {
                        rENode = new RENode(compilerState, 18, null);
                        break;
                    }
                    case 'S': {
                        rENode = new RENode(compilerState, 19, null);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (compilerState.cx.getLanguageVersion() != 0 && compilerState.cx.getLanguageVersion() <= 140) {
                            switch (c) {
                                case '0': {
                                    compilerState.index = n;
                                    n2 = this.doOctal(compilerState);
                                    n = compilerState.index;
                                    rENode = new RENode(compilerState, 22, null);
                                    c = (char)n2;
                                    break;
                                }
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    n2 = NativeRegExp.unDigit(c);
                                    n5 = 1;
                                    while (++n < cArray.length && NativeRegExp.isDigit(c = cArray[n])) {
                                        n2 = 10 * n2 + NativeRegExp.unDigit(c);
                                        ++n5;
                                    }
                                    if ((n2 == 8 || n2 == 9) && n2 > compilerState.parenCount) {
                                        n3 = --n;
                                        bl2 = true;
                                        bl = true;
                                        break;
                                    }
                                    if (n5 > 1 || n2 > compilerState.parenCount) {
                                        compilerState.index = n3;
                                        n2 = this.doOctal(compilerState);
                                        n = compilerState.index;
                                        rENode = new RENode(compilerState, 22, null);
                                        c = (char)n2;
                                        break;
                                    }
                                    --n;
                                    rENode = new RENode(compilerState, 20, null);
                                    rENode.num = n2 - 1;
                                    rENode.flags = (byte)4;
                                    bl = true;
                                }
                            }
                            break;
                        }
                        if (c == '0') {
                            rENode = new RENode(compilerState, 22, null);
                            c = '\u0000';
                            break;
                        }
                        n2 = NativeRegExp.unDigit(c);
                        n5 = 1;
                        while (++n < cArray.length && NativeRegExp.isDigit(c = cArray[n])) {
                            n2 = 10 * n2 + NativeRegExp.unDigit(c);
                            ++n5;
                        }
                        --n;
                        rENode = new RENode(compilerState, 20, null);
                        rENode.num = n2 - 1;
                        rENode.flags = (byte)4;
                        bl = true;
                        break;
                    }
                    case 'x': {
                        n3 = n++;
                        if (n < cArray.length && NativeRegExp.isHex(c = cArray[n])) {
                            n2 = NativeRegExp.unHex(c);
                            if (++n < cArray.length && NativeRegExp.isHex(c = cArray[n])) {
                                n2 <<= 4;
                                n2 += NativeRegExp.unHex(c);
                            } else if (compilerState.cx.getLanguageVersion() != 0 && compilerState.cx.getLanguageVersion() <= 140) {
                                --n;
                            } else {
                                n = n3;
                                n2 = 120;
                            }
                        } else {
                            n = n3;
                            n2 = 120;
                        }
                        rENode = new RENode(compilerState, 22, null);
                        c = (char)n2;
                        break;
                    }
                    case 'c': {
                        c = cArray[++n];
                        if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z')) {
                            n3 = n -= 2;
                            bl2 = true;
                            bl = true;
                            break;
                        }
                        c = Character.toUpperCase(c);
                        c = (char)(c ^ 0x40);
                        rENode = new RENode(compilerState, 22, null);
                        break;
                    }
                    case 'u': {
                        if (n + 4 < cArray.length && NativeRegExp.isHex(cArray[n + 1]) && NativeRegExp.isHex(cArray[n + 2]) && NativeRegExp.isHex(cArray[n + 3]) && NativeRegExp.isHex(cArray[n + 4])) {
                            n2 = (((NativeRegExp.unHex(cArray[n + 1]) << 4) + NativeRegExp.unHex(cArray[n + 2]) << 4) + NativeRegExp.unHex(cArray[n + 3]) << 4) + NativeRegExp.unHex(cArray[n + 4]);
                            c = (char)n2;
                            n += 4;
                            rENode = new RENode(compilerState, 22, null);
                            break;
                        }
                        n3 = n;
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    default: {
                        n3 = n;
                        bl2 = true;
                        bl = true;
                    }
                }
                if (rENode != null && !bl) {
                    rENode.chr = c;
                    rENode.flags = (byte)6;
                }
                bl = false;
                if (!bl2) {
                    ++n;
                    break;
                }
                bl2 = false;
            }
            default: {
                while (++n != cArray.length && metachars.indexOf(cArray[n]) == -1) {
                }
                int n5 = n - n3;
                if (n != cArray.length && n5 > 1 && closurechars.indexOf(cArray[n]) != -1) {
                    --n;
                    --n5;
                }
                if (n5 > 255) {
                    n5 = 255;
                    n = n3 + n5;
                }
                rENode = new RENode(compilerState, n5 == 1 ? (byte)22 : 21, new Integer(n3));
                rENode.flags = (byte)4;
                if (n5 > 1) {
                    rENode.kid2 = n;
                    break;
                }
                rENode.flags = (byte)(rENode.flags | 2);
                rENode.chr = cArray[n3];
            }
        }
        compilerState.index = n;
        return rENode;
    }

    private int doOctal(CompilerState compilerState) {
        char c;
        char[] cArray = compilerState.source;
        int n = compilerState.index;
        int n2 = 0;
        while (++n < cArray.length && '0' <= (c = cArray[n]) && c <= '7') {
            int n3 = 8 * n2 + (c - 48);
            if (n3 > 255) break;
            n2 = n3;
        }
        compilerState.index = --n;
        return n2;
    }

    static char getEscape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
        }
        throw new RuntimeException();
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    static int unDigit(char c) {
        return c - 48;
    }

    static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    static int unHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return 10 + Character.toLowerCase(c) - 97;
    }

    static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    private String tail(char[] cArray, int n) {
        return new String(cArray, n, cArray.length - n);
    }

    private static boolean matchChar(int n, char c, char c2) {
        if (c == c2) {
            return true;
        }
        if ((n & 2) != 0) {
            return (c = Character.toUpperCase(c)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase(c) == Character.toLowerCase(c2);
        }
        return false;
    }

    int greedyRecurse(GreedyState greedyState, int n, int n2) {
        int n3;
        int n4 = greedyState.state.parenCount;
        boolean bl = greedyState.state.goForBroke;
        greedyState.state.goForBroke = false;
        int n5 = this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n);
        greedyState.state.complete = -1;
        greedyState.state.goForBroke = bl;
        if (n5 == -1) {
            int n6;
            greedyState.state.parenCount = n4;
            if (n2 != -1) {
                this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n2);
            }
            if ((n6 = this.matchRENodes(greedyState.state, greedyState.next, greedyState.stop, n)) != -1) {
                if (greedyState.stop == null) {
                    greedyState.state.complete = n6;
                    return n;
                }
                return n;
            }
            return -1;
        }
        if (n5 == n) {
            if (n2 != -1) {
                this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n2);
            }
            return n5;
        }
        if (greedyState.maxKid == 0 || ++greedyState.kidCount < greedyState.maxKid) {
            n3 = this.greedyRecurse(greedyState, n5, n);
            if (n3 != -1) {
                return n3;
            }
            if (greedyState.maxKid != 0) {
                --greedyState.kidCount;
            }
        }
        greedyState.state.parenCount = n4;
        this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n);
        n3 = this.matchRENodes(greedyState.state, greedyState.next, greedyState.stop, n5);
        if (n3 != -1) {
            if (greedyState.stop == null) {
                greedyState.state.complete = n3;
                return n5;
            }
            this.matchRENodes(greedyState.state, greedyState.kid, greedyState.next, n);
            return n5;
        }
        return -1;
    }

    int matchGreedyKid(MatchState matchState, RENode rENode, RENode rENode2, int n, int n2, int n3) {
        GreedyState greedyState = new GreedyState();
        greedyState.state = matchState;
        greedyState.kid = (RENode)rENode.kid;
        greedyState.next = rENode.next;
        greedyState.maxKid = rENode.op == 6 ? rENode.max : (short)0;
        greedyState.stop = null;
        greedyState.kidCount = n;
        int n4 = this.greedyRecurse(greedyState, n2, n3);
        if (n4 != -1 || rENode2 == null) {
            return n4;
        }
        greedyState.kidCount = n;
        greedyState.stop = rENode2;
        return this.greedyRecurse(greedyState, n2, n3);
    }

    int matchNonGreedyKid(MatchState matchState, RENode rENode, int n, int n2, int n3) {
        int n4 = this.matchRENodes(matchState, rENode.next, null, n3);
        if (matchState.goForBroke && matchState.complete != -1) {
            return matchState.complete;
        }
        if (n4 != -1) {
            matchState.complete = n4;
            return n3;
        }
        if (n4 != -1) {
            return n3;
        }
        int n5 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n3);
        if (n5 == -1) {
            return -1;
        }
        if (matchState.goForBroke && matchState.complete != -1) {
            return matchState.complete;
        }
        if (n5 == n3) {
            return n5;
        }
        return this.matchNonGreedyKid(matchState, rENode, n, n2, n5);
    }

    boolean isLineTerminator(char c) {
        return TokenStream.isJSLineTerminator(c);
    }

    int matchRENodes(MatchState matchState, RENode rENode, RENode rENode2, int n) {
        char[] cArray = matchState.input;
        block33: while (rENode != rENode2 && rENode != null) {
            block0 : switch (rENode.op) {
                case 0: {
                    break;
                }
                case 1: {
                    if (rENode.next.op != 1) {
                        rENode = (RENode)rENode.kid;
                        continue block33;
                    }
                    int n2 = matchState.parenCount;
                    int n3 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode2, n);
                    if (matchState.goForBroke && matchState.complete != -1) {
                        return matchState.complete;
                    }
                    if (n3 != -1) {
                        return n3;
                    }
                    int n4 = n2;
                    while (n4 < matchState.parenCount) {
                        matchState.parens[n4] = null;
                        ++n4;
                    }
                    matchState.parenCount = n2;
                    break;
                }
                case 6: {
                    int n4;
                    int n5 = -1;
                    int n2 = 0;
                    while (n2 < rENode.min) {
                        n4 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n);
                        if (n4 == -1) {
                            return -1;
                        }
                        if (matchState.goForBroke && matchState.complete != -1) {
                            return matchState.complete;
                        }
                        n5 = n;
                        n = n4;
                        ++n2;
                    }
                    if (n2 == rENode.max) break;
                    if ((rENode.flags & 0x80) == 0) {
                        n4 = this.matchGreedyKid(matchState, rENode, rENode2, n2, n, n5);
                        if (n4 == -1) {
                            if (n5 == -1) break;
                            n = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n5);
                            if (!matchState.goForBroke || matchState.complete == -1) break;
                            return matchState.complete;
                        }
                        if (matchState.goForBroke && matchState.complete != -1) {
                            return matchState.complete;
                        }
                        n = n4;
                        break;
                    }
                    if ((n = this.matchNonGreedyKid(matchState, rENode, n2, rENode.max, n)) == -1) {
                        return -1;
                    }
                    if (!matchState.goForBroke || matchState.complete == -1) break;
                    return matchState.complete;
                }
                case 8: {
                    int n6 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n);
                    if (n6 == -1) {
                        return -1;
                    }
                    if ((rENode.flags & 0x80) == 0) {
                        if ((n6 = this.matchGreedyKid(matchState, rENode, rENode2, 1, n6, n)) == -1) {
                            n = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n);
                            if (matchState.goForBroke && matchState.complete != -1) {
                                return matchState.complete;
                            }
                        } else {
                            if (matchState.goForBroke && matchState.complete != -1) {
                                return matchState.complete;
                            }
                            n = n6;
                        }
                    } else {
                        n = this.matchNonGreedyKid(matchState, rENode, 1, 0, n6);
                        if (matchState.goForBroke && matchState.complete != -1) {
                            return matchState.complete;
                        }
                    }
                    if (n != -1) break;
                    return -1;
                }
                case 7: {
                    if ((rENode.flags & 0x80) == 0) {
                        int n7 = this.matchGreedyKid(matchState, rENode, rENode2, 0, n, -1);
                        if (n7 == -1) break;
                        if (matchState.goForBroke && matchState.complete != -1) {
                            return matchState.complete;
                        }
                        n = n7;
                        break;
                    }
                    if ((n = this.matchNonGreedyKid(matchState, rENode, 0, 0, n)) == -1) {
                        return -1;
                    }
                    if (!matchState.goForBroke || matchState.complete == -1) break;
                    return matchState.complete;
                }
                case 9: {
                    int n4;
                    int n8 = matchState.parenCount;
                    if ((rENode.flags & 0x80) != 0) {
                        n4 = this.matchRENodes(matchState, rENode.next, rENode2, n);
                        if (matchState.goForBroke && matchState.complete != -1) {
                            return matchState.complete;
                        }
                        if (n4 != -1) {
                            return n4;
                        }
                    }
                    n4 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n);
                    if (matchState.goForBroke && matchState.complete != -1) {
                        return matchState.complete;
                    }
                    if (n4 == -1) {
                        int n9 = n8;
                        while (n9 < matchState.parenCount) {
                            matchState.parens[n9] = null;
                            ++n9;
                        }
                        matchState.parenCount = n8;
                        break;
                    }
                    int n10 = this.matchRENodes(matchState, rENode.next, rENode2, n4);
                    if (matchState.goForBroke && matchState.complete != -1) {
                        return matchState.complete;
                    }
                    if (n10 == -1) {
                        int n11 = n8;
                        while (n11 < matchState.parenCount) {
                            matchState.parens[n11] = null;
                            ++n11;
                        }
                        matchState.parenCount = n8;
                        break;
                    }
                    return n10;
                }
                case 39: {
                    rENode = (RENode)rENode.kid;
                    continue block33;
                }
                case 40: {
                    break;
                }
                case 10: {
                    int n2 = rENode.num;
                    rENode = (RENode)rENode.kid;
                    SubString subString = matchState.parens[n2];
                    if (subString == null) {
                        subString = matchState.parens[n2] = new SubString();
                        subString.charArray = cArray;
                    }
                    subString.index = n;
                    subString.length = 0;
                    if (n2 < matchState.parenCount) continue block33;
                    matchState.parenCount = n2 + 1;
                    continue block33;
                }
                case 11: {
                    int n2 = rENode.num;
                    SubString subString = matchState.parens[n2];
                    if (subString == null) {
                        throw new RuntimeException("Paren problem");
                    }
                    subString.length = n - subString.index;
                    break;
                }
                case 41: {
                    int n12 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n);
                    if (matchState.goForBroke && matchState.complete != -1) {
                        return matchState.complete;
                    }
                    if (n12 != -1) break;
                    return -1;
                }
                case 42: {
                    int n13 = this.matchRENodes(matchState, (RENode)rENode.kid, rENode.next, n);
                    if (matchState.goForBroke && matchState.complete != -1) {
                        return matchState.complete;
                    }
                    if (n13 == -1) break;
                    return -1;
                }
                case 20: {
                    int n2 = rENode.num;
                    if (n2 >= matchState.parens.length) {
                        Context.reportError(ScriptRuntime.getMessage("msg.bad.backref", null));
                        return -1;
                    }
                    SubString subString = matchState.parens[n2];
                    if (subString == null) {
                        subString = matchState.parens[n2] = new SubString();
                    }
                    int n4 = subString.length;
                    int n14 = 0;
                    while (n14 < n4) {
                        if (n >= cArray.length) {
                            return matchState.noMoreInput();
                        }
                        if (!NativeRegExp.matchChar(matchState.flags, cArray[n], subString.charArray[subString.index + n14])) {
                            return -1;
                        }
                        ++n14;
                        ++n;
                    }
                    break;
                }
                case 13: {
                    char c;
                    int n4;
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (rENode.bitmap == null) {
                        char[] cArray2 = rENode.s != null ? rENode.s : this.source.toCharArray();
                        rENode.buildBitmap(matchState, cArray2, (matchState.flags & 2) != 0);
                    }
                    if ((n4 = (c = cArray[n]) >>> 3) >= rENode.bmsize) {
                        if (rENode.kid2 == -1) {
                            ++n;
                            break;
                        }
                        return -1;
                    }
                    int n15 = c & 7;
                    if ((rENode.bitmap[n4] & (n15 = 1 << n15)) != 0) {
                        ++n;
                        break;
                    }
                    return -1;
                }
                case 12: {
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (!this.isLineTerminator(cArray[n])) {
                        ++n;
                        break;
                    }
                    return -1;
                }
                case 38: {
                    int n16 = n;
                    while (n16 < cArray.length) {
                        int n17 = this.matchRENodes(matchState, rENode.next, rENode2, n16);
                        if (n17 != -1) {
                            return n17;
                        }
                        if (this.isLineTerminator(cArray[n16])) {
                            return -1;
                        }
                        ++n16;
                    }
                    return matchState.noMoreInput();
                }
                case 24: {
                    int n18 = n;
                    while (n18 < cArray.length) {
                        if (this.isLineTerminator(cArray[n18])) break;
                        ++n18;
                    }
                    while (n18 >= n) {
                        int n19 = this.matchRENodes(matchState, rENode.next, rENode2, n18);
                        if (n19 != -1) {
                            n = n18;
                            break block0;
                        }
                        --n18;
                    }
                    break;
                }
                case 4: {
                    if (n == 0 || !NativeRegExp.isWord(cArray[n - 1])) {
                        if (n >= cArray.length) {
                            return matchState.noMoreInput();
                        }
                        if (NativeRegExp.isWord(cArray[n])) break;
                        return -1;
                    }
                    if (n >= cArray.length || !NativeRegExp.isWord(cArray[n])) break;
                    return -1;
                }
                case 5: {
                    if (n == 0 || !NativeRegExp.isWord(cArray[n - 1])) {
                        if (n >= cArray.length || !NativeRegExp.isWord(cArray[n])) break;
                        return -1;
                    }
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (NativeRegExp.isWord(cArray[n])) break;
                    return -1;
                }
                case 3: 
                case 26: {
                    if (n == cArray.length) break;
                    Context context = Context.getCurrentContext();
                    RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
                    if (regExpImpl.multiline || (matchState.flags & 4) != 0) {
                        if (this.isLineTerminator(cArray[n])) break;
                        return -1;
                    }
                    return -1;
                }
                case 2: {
                    Context context = Context.getCurrentContext();
                    RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
                    if (n == 0) break;
                    if (regExpImpl.multiline || (matchState.flags & 4) != 0) {
                        if (n >= cArray.length) {
                            return matchState.noMoreInput();
                        }
                        if (this.isLineTerminator(cArray[n - 1])) break;
                    }
                    return -1;
                }
                case 14: {
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (!NativeRegExp.isDigit(cArray[n])) {
                        return -1;
                    }
                    ++n;
                    break;
                }
                case 15: {
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (NativeRegExp.isDigit(cArray[n])) {
                        return -1;
                    }
                    ++n;
                    break;
                }
                case 16: {
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (!NativeRegExp.isWord(cArray[n])) {
                        return -1;
                    }
                    ++n;
                    break;
                }
                case 17: {
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (NativeRegExp.isWord(cArray[n])) {
                        return -1;
                    }
                    ++n;
                    break;
                }
                case 18: {
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (!TokenStream.isJSSpace(cArray[n]) && !TokenStream.isJSLineTerminator(cArray[n])) {
                        return -1;
                    }
                    ++n;
                    break;
                }
                case 19: {
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (TokenStream.isJSSpace(cArray[n]) || TokenStream.isJSLineTerminator(cArray[n])) {
                        return -1;
                    }
                    ++n;
                    break;
                }
                case 22: {
                    if (n >= cArray.length) {
                        return matchState.noMoreInput();
                    }
                    if (!NativeRegExp.matchChar(matchState.flags, rENode.chr, cArray[n])) {
                        return -1;
                    }
                    ++n;
                    break;
                }
                case 21: {
                    char[] cArray3 = rENode.s != null ? rENode.s : this.source.toCharArray();
                    int n20 = (Integer)rENode.kid;
                    int n21 = rENode.kid2 - n20;
                    int n22 = 0;
                    while (n22 < n21) {
                        if (n >= cArray.length) {
                            return matchState.noMoreInput();
                        }
                        if (!NativeRegExp.matchChar(matchState.flags, cArray[n], cArray3[n20 + n22])) {
                            return -1;
                        }
                        ++n22;
                        ++n;
                    }
                    break;
                }
                case 23: {
                    break;
                }
                case 43: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported by node matcher");
                }
            }
            rENode = rENode.next;
        }
        return n;
    }

    int matchRegExp(MatchState matchState, RENode rENode, int n) {
        int n2 = n;
        while (n2 <= matchState.input.length) {
            matchState.skipped = n2 - n;
            matchState.parenCount = 0;
            int n3 = this.matchRENodes(matchState, rENode, null, n2);
            if (n3 != -1) {
                return n3;
            }
            ++n2;
        }
        return -1;
    }

    Object executeRegExp(Context context, Scriptable scriptable, RegExpImpl regExpImpl, String string, int[] nArray, int n) {
        Object object;
        Scriptable scriptable2;
        Object object2;
        int n2;
        NativeRegExp nativeRegExp = this;
        MatchState matchState = new MatchState();
        matchState.inputExhausted = false;
        matchState.anchoring = false;
        matchState.flags = nativeRegExp.flags;
        matchState.scope = scriptable;
        int n3 = nArray[0];
        char[] cArray = string.toCharArray();
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        int n4 = n3;
        matchState.cpbegin = 0;
        matchState.cpend = cArray.length;
        matchState.start = n3;
        matchState.skipped = 0;
        matchState.input = cArray;
        matchState.complete = -1;
        matchState.goForBroke = true;
        matchState.parenCount = 0;
        matchState.maybeParens = new SubString[nativeRegExp.parenCount];
        matchState.parens = new SubString[nativeRegExp.parenCount];
        if ((n4 = this.matchRegExp(matchState, this.ren, n4)) == -1) {
            if (n != 2 || !matchState.inputExhausted) {
                return null;
            }
            return Undefined.instance;
        }
        nArray[0] = n2 = n4 - matchState.cpbegin;
        int n5 = n2 - (n3 + matchState.skipped);
        int n6 = n4;
        n4 -= n5;
        if (n == 0) {
            object2 = Boolean.TRUE;
            scriptable2 = null;
        } else {
            object = ScriptableObject.getTopLevelScope(scriptable);
            object2 = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
            scriptable2 = (Scriptable)object2;
            String string2 = new String(cArray, n4, n5);
            scriptable2.put(0, scriptable2, (Object)string2);
        }
        if (matchState.parenCount > nativeRegExp.parenCount) {
            throw new RuntimeException();
        }
        if (matchState.parenCount == 0) {
            regExpImpl.parens.setSize(0);
            regExpImpl.lastParen = SubString.emptySubString;
        } else {
            object = null;
            regExpImpl.parens.setSize(matchState.parenCount);
            int n7 = 0;
            while (n7 < matchState.parenCount) {
                object = matchState.parens[n7];
                regExpImpl.parens.setElementAt(object, n7);
                if (n != 0) {
                    String string3 = object == null ? "" : ((SubString)object).toString();
                    scriptable2.put(n7 + 1, scriptable2, (Object)string3);
                }
                ++n7;
            }
            regExpImpl.lastParen = object;
        }
        if (n != 0) {
            scriptable2.put("index", scriptable2, (Object)new Integer(n3 + matchState.skipped));
            scriptable2.put("input", scriptable2, (Object)string);
        }
        if (regExpImpl.lastMatch == null) {
            regExpImpl.lastMatch = new SubString();
            regExpImpl.leftContext = new SubString();
            regExpImpl.rightContext = new SubString();
        }
        regExpImpl.lastMatch.charArray = cArray;
        regExpImpl.lastMatch.index = n4;
        regExpImpl.lastMatch.length = n5;
        regExpImpl.leftContext.charArray = cArray;
        if (context.getLanguageVersion() == 120) {
            regExpImpl.leftContext.index = n3;
            regExpImpl.leftContext.length = matchState.skipped;
        } else {
            regExpImpl.leftContext.index = 0;
            regExpImpl.leftContext.length = n3 + matchState.skipped;
        }
        regExpImpl.rightContext.charArray = cArray;
        regExpImpl.rightContext.index = n6;
        regExpImpl.rightContext.length = matchState.cpend - n6;
        return object2;
    }

    public byte getFlags() {
        return this.flags;
    }

    private void reportError(String string, String string2, CompilerState compilerState) {
        Object[] objectArray = new Object[]{string2};
        throw NativeGlobal.constructError(compilerState.cx, "SyntaxError", ScriptRuntime.getMessage(string, objectArray), compilerState.scope);
    }

    protected int getIdDefaultAttributes(int n) {
        switch (n) {
            case 1: {
                return 4;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 5;
            }
        }
        return super.getIdDefaultAttributes(n);
    }

    protected Object getIdValue(int n) {
        switch (n) {
            case 1: {
                return this.wrap_long(0xFFFFFFFFL & (long)this.lastIndex);
            }
            case 2: {
                return this.source;
            }
            case 3: {
                return this.wrap_boolean((this.flags & 1) != 0);
            }
            case 4: {
                return this.wrap_boolean((this.flags & 2) != 0);
            }
            case 5: {
                return this.wrap_boolean((this.flags & 4) != 0);
            }
        }
        return super.getIdValue(n);
    }

    protected void setIdValue(int n, Object object) {
        if (n == 1) {
            this.setLastIndex(ScriptRuntime.toInt32(object));
            return;
        }
        super.setIdValue(n, object);
    }

    void setLastIndex(int n) {
        this.lastIndex = n;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return 1;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return this.realThis(scriptable2, idFunction, false).compile(context, scriptable, objectArray);
                }
                case 7: {
                    return this.realThis(scriptable2, idFunction, true).toString();
                }
                case 8: {
                    return this.realThis(scriptable2, idFunction, false).exec(context, scriptable, objectArray);
                }
                case 9: {
                    return this.realThis(scriptable2, idFunction, false).test(context, scriptable, objectArray);
                }
                case 10: {
                    return this.realThis(scriptable2, idFunction, false).prefix(context, scriptable, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeRegExp realThis(Scriptable scriptable, IdFunction idFunction, boolean bl) {
        while (!(scriptable instanceof NativeRegExp)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, bl);
        }
        return (NativeRegExp)scriptable;
    }

    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return "compile";
                }
                case 7: {
                    return "toString";
                }
                case 8: {
                    return "exec";
                }
                case 9: {
                    return "test";
                }
                case 10: {
                    return "prefix";
                }
            }
        }
        return null;
    }

    protected int maxInstanceId() {
        return 5;
    }

    protected int mapNameToId(String string) {
        char c;
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 6) {
            c = string.charAt(0);
            if (c == 'g') {
                string2 = "global";
                n = 3;
            } else if (c == 's') {
                string2 = "source";
                n = 2;
            }
        } else if (n2 == 9) {
            c = string.charAt(0);
            if (c == 'l') {
                string2 = "lastIndex";
                n = 1;
            } else if (c == 'm') {
                string2 = "multiline";
                n = 5;
            }
        } else if (n2 == 10) {
            string2 = "ignoreCase";
            n = 4;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n != 0 || !this.prototypeFlag) {
            return n;
        }
        n = 0;
        string2 = null;
        switch (string.length()) {
            case 4: {
                c = string.charAt(0);
                if (c == 'e') {
                    string2 = "exec";
                    n = 8;
                    break;
                }
                if (c != 't') break;
                string2 = "test";
                n = 9;
                break;
            }
            case 6: {
                string2 = "prefix";
                n = 10;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 6;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 7;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    static {
        reopname = null;
    }
}

