/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.vo;

import com.sysmon.WLMonitor.UI.ServerTabPanelThread;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class MainVO {
    static String configFileName = "config.xml";
    static boolean[] mute = new boolean[20];
    static boolean[][] errorServerItem = new boolean[20][20];
    static boolean[] errorServer = new boolean[20];
    static boolean error;
    static JTabbedPane xJTabbedPane;
    static boolean screenfix;
    static ImageIcon errorImageIcon;
    static ImageIcon normalImageIcon;
    static Toolkit toolkit;

    static {
        xJTabbedPane = ServerTabPanelThread.getInstance().getXJTabbedPane();
        screenfix = false;
        errorImageIcon = new ImageIcon("icons/errorTabItemIcon.gif");
        normalImageIcon = new ImageIcon("icons/normalTabItemIcon.gif");
        toolkit = Toolkit.getDefaultToolkit();
    }

    public static void setMuteAll(boolean flg) {
        int i = 0;
        while (i < 20) {
            MainVO.mute[i] = flg;
            ++i;
        }
    }

    public static synchronized boolean getMute(int pos) {
        return mute[pos];
    }

    public static synchronized void setMute(int pos, boolean mute) {
        MainVO.mute[pos] = mute;
    }

    public static synchronized void clearError() {
        error = false;
        int i = 0;
        while (i < 20) {
            MainVO.errorServer[i] = false;
            int j = 0;
            while (j < 20) {
                MainVO.errorServerItem[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public static synchronized void errorCompute() {
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                if (errorServerItem[i][j]) {
                    MainVO.errorServer[i] = true;
                }
                ++j;
            }
            if (errorServer[i]) {
                error = true;
            }
            ++i;
        }
    }

    public static boolean getError() {
        return error;
    }

    public static boolean getServerError(int serverPos) {
        return errorServer[serverPos];
    }

    public static boolean getServerItemError(int serverPos, int tabPos) {
        return errorServerItem[serverPos][tabPos];
    }

    public static int getFirstServerErrorPos() {
        int i = 0;
        while (i < 20) {
            if (errorServer[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getFirstServerItemErrorPos(int serverPos) {
        int i = 0;
        while (i < 20) {
            if (errorServerItem[serverPos][i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static synchronized void setError(String ServerName, int tabPos, boolean error) {
        int serverPos = -1;
        int i = 0;
        while (i < xJTabbedPane.getTabCount()) {
            if (xJTabbedPane.getTitleAt(i).equals(ServerName)) {
                serverPos = i;
                break;
            }
            ++i;
        }
        if (serverPos == -1) {
            return;
        }
        MainVO.errorServerItem[serverPos][tabPos] = error;
    }

    public static void playAlarmSound() {
        boolean flg = false;
        int i = 0;
        while (i < 20) {
            if (errorServer[i] && !mute[i]) {
                flg = true;
            }
            ++i;
        }
        if (flg) {
            toolkit.beep();
        }
    }

    public static boolean[] getMute() {
        return mute;
    }

    public static void setMute(boolean[] mute) {
        MainVO.mute = mute;
    }

    public static boolean isScreenfix() {
        return screenfix;
    }

    public static void setScreenfix(boolean screenfix) {
        MainVO.screenfix = screenfix;
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public static void setConfigFileName(String configFileName) {
        MainVO.configFileName = configFileName;
    }
}

