/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.util;

import com.sysmon.WLMonitor.util.BasicLinkButtonUI;
import java.awt.Color;
import java.awt.Cursor;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class JLinkButton
extends JButton {
    private static final String uiString = "LinkButtonUI";
    public static final int ALWAYS_UNDERLINE = 0;
    public static final int HOVER_UNDERLINE = 1;
    public static final int NEVER_UNDERLINE = 2;
    public static final int SYSTEM_DEFAULT = 3;
    private int linkBehavior = 3;
    private Color linkColor = Color.blue;
    private Color colorPressed = Color.red;
    private Color visitedLinkColor = new Color(128, 0, 128);
    private Color disabledLinkColor;
    private URL buttonURL;
    private Action defaultAction;
    private boolean isLinkVisited;

    public JLinkButton() {
        this(null, null, null);
    }

    public JLinkButton(Action action) {
        this();
        this.setAction(action);
    }

    public JLinkButton(Icon icon) {
        this(null, icon, null);
    }

    public JLinkButton(String s) {
        this(s, null, null);
    }

    public JLinkButton(URL url) {
        this(null, null, url);
    }

    public JLinkButton(String s, URL url) {
        this(s, null, url);
    }

    public JLinkButton(Icon icon, URL url) {
        this(null, icon, url);
    }

    public JLinkButton(String text, Icon icon, URL url) {
        super(text, icon);
        if (text == null && url != null) {
            this.setText(url.toExternalForm());
        }
        this.setLinkURL(url);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.addActionListener(this.defaultAction);
    }

    public void updateUI() {
        this.setUI(BasicLinkButtonUI.createUI(this));
    }

    private void setDefault() {
        UIManager.getDefaults().put(uiString, "BasicLinkButtonUI");
    }

    public String getUIClassID() {
        return uiString;
    }

    protected void setupToolTipText() {
        String tip = null;
        if (this.buttonURL != null) {
            tip = this.buttonURL.toExternalForm();
        }
        this.setToolTipText(tip);
    }

    public void setLinkBehavior(int bnew) {
        this.checkLinkBehaviour(bnew);
        int old = this.linkBehavior;
        this.linkBehavior = bnew;
        this.firePropertyChange("linkBehavior", old, bnew);
        this.repaint();
    }

    private void checkLinkBehaviour(int beha) {
        if (beha != 0 && beha != 1 && beha != 2 && beha != 3) {
            throw new IllegalArgumentException("Not a legal LinkBehavior");
        }
    }

    public int getLinkBehavior() {
        return this.linkBehavior;
    }

    public void setLinkColor(Color color) {
        Color colorOld = this.linkColor;
        this.linkColor = color;
        this.firePropertyChange("linkColor", colorOld, color);
        this.repaint();
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setActiveLinkColor(Color colorNew) {
        Color colorOld = this.colorPressed;
        this.colorPressed = colorNew;
        this.firePropertyChange("activeLinkColor", colorOld, colorNew);
        this.repaint();
    }

    public Color getActiveLinkColor() {
        return this.colorPressed;
    }

    public void setDisabledLinkColor(Color color) {
        Color colorOld = this.disabledLinkColor;
        this.disabledLinkColor = color;
        this.firePropertyChange("disabledLinkColor", colorOld, color);
        if (!this.isEnabled()) {
            this.repaint();
        }
    }

    public Color getDisabledLinkColor() {
        return this.disabledLinkColor;
    }

    public void setVisitedLinkColor(Color colorNew) {
        Color colorOld = this.visitedLinkColor;
        this.visitedLinkColor = colorNew;
        this.firePropertyChange("visitedLinkColor", colorOld, colorNew);
        this.repaint();
    }

    public Color getVisitedLinkColor() {
        return this.visitedLinkColor;
    }

    public URL getLinkURL() {
        return this.buttonURL;
    }

    public void setLinkURL(URL url) {
        URL urlOld = this.buttonURL;
        this.buttonURL = url;
        this.setupToolTipText();
        this.firePropertyChange("linkURL", urlOld, url);
        this.revalidate();
        this.repaint();
    }

    public void setLinkVisited(boolean flagNew) {
        boolean flagOld = this.isLinkVisited;
        this.isLinkVisited = flagNew;
        this.firePropertyChange("linkVisited", flagOld, flagNew);
        this.repaint();
    }

    public boolean isLinkVisited() {
        return this.isLinkVisited;
    }

    public void setDefaultAction(Action actionNew) {
        Action actionOld = this.defaultAction;
        this.defaultAction = actionNew;
        this.firePropertyChange("defaultAction", actionOld, actionNew);
    }

    public Action getDefaultAction() {
        return this.defaultAction;
    }

    protected String paramString() {
        String str = this.linkBehavior == 0 ? "ALWAYS_UNDERLINE" : (this.linkBehavior == 1 ? "HOVER_UNDERLINE" : (this.linkBehavior == 2 ? "NEVER_UNDERLINE" : "SYSTEM_DEFAULT"));
        String colorStr = this.linkColor == null ? "" : this.linkColor.toString();
        String colorPressStr = this.colorPressed == null ? "" : this.colorPressed.toString();
        String disabledLinkColorStr = this.disabledLinkColor == null ? "" : this.disabledLinkColor.toString();
        String visitedLinkColorStr = this.visitedLinkColor == null ? "" : this.visitedLinkColor.toString();
        String buttonURLStr = this.buttonURL == null ? "" : this.buttonURL.toString();
        String isLinkVisitedStr = this.isLinkVisited ? "true" : "false";
        return String.valueOf(super.paramString()) + ",linkBehavior=" + str + ",linkURL=" + buttonURLStr + ",linkColor=" + colorStr + ",activeLinkColor=" + colorPressStr + ",disabledLinkColor=" + disabledLinkColorStr + ",visitedLinkColor=" + visitedLinkColorStr + ",linkvisitedString=" + isLinkVisitedStr;
    }
}

