/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.log;

import com.sysmon.WLMonitor.log.ConsoleLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    static Logger logger = null;
    private PrintWriter pwWriter = null;
    private String sYYYYMMDD = "";
    private String sHHMMSS = "";
    private String sLogName = "";
    private String sOldLogName = "";
    private String sNewLogName = "";
    private String sDomainName = "none";
    private String sLogDir = "logs";
    private SimpleDateFormat sdfYYYYMDDD = new SimpleDateFormat("yyyyMMdd");
    private SimpleDateFormat sdfHHMMSS = new SimpleDateFormat("HHmmss");
    private Date dNow = null;
    File file;

    public static Logger getInstance() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    public void setLogger(String sDomainName) {
        this.sDomainName = sDomainName;
    }

    private synchronized void checkDate() {
        this.dNow = new Date();
        this.sYYYYMMDD = this.sdfYYYYMDDD.format(this.dNow);
        this.sHHMMSS = this.sdfHHMMSS.format(this.dNow);
        this.sNewLogName = String.valueOf(this.sLogDir) + "/" + this.sDomainName + "_" + this.sYYYYMMDD;
        if (!this.sNewLogName.equals(this.sOldLogName)) {
            this.sOldLogName = this.sNewLogName;
            this.sLogName = String.valueOf(this.sNewLogName) + "_" + this.sHHMMSS + "_" + System.getProperty("user.name") + ".log";
            if (this.pwWriter != null) {
                try {
                    this.pwWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pwWriter = null;
            }
            try {
                FileWriter fw = new FileWriter(this.sLogName, true);
                this.pwWriter = new PrintWriter((Writer)new BufferedWriter(fw), true);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.pwWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(System.out)), true);
                this.pwWriter.println("Can't open log file : " + e.getMessage());
                this.pwWriter.println("Log will be printed into System.out");
            }
        }
    }

    public void printInfo(String sMsg) {
        this.printInfo("", sMsg);
    }

    public void printInfo(String sServerName, String sMsg) {
        this.checkDate();
        String msg = "[" + this.sYYYYMMDD + "_" + this.sHHMMSS + "][I] " + sServerName + " " + sMsg;
        this.pwWriter.println(msg);
        ConsoleLogger.printLoggerMsg(msg);
    }

    public void printErr(String sMsg) {
        this.printErr("", sMsg);
    }

    public void printErr(String sServerName, String sMsg) {
        this.checkDate();
        String msg = "[" + this.sYYYYMMDD + "_" + this.sHHMMSS + "][E] " + sServerName + " " + sMsg;
        this.pwWriter.println(msg);
        ConsoleLogger.printLoggerMsg(msg);
    }

    public Date getDNow() {
        return this.dNow;
    }

    public File getFile() {
        return this.file;
    }

    public PrintWriter getPwWriter() {
        return this.pwWriter;
    }

    public SimpleDateFormat getSdfHHMMSS() {
        return this.sdfHHMMSS;
    }

    public SimpleDateFormat getSdfYYYYMDDD() {
        return this.sdfYYYYMDDD;
    }

    public String getSHHMMSS() {
        return this.sHHMMSS;
    }

    public String getSLogDir() {
        return this.sLogDir;
    }

    public String getSLogName() {
        return this.sLogName;
    }

    public String getSYYYYMMDD() {
        return this.sYYYYMMDD;
    }

    public void setDNow(Date date) {
        this.dNow = date;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setPwWriter(PrintWriter writer) {
        this.pwWriter = writer;
    }

    public void setSdfHHMMSS(SimpleDateFormat format) {
        this.sdfHHMMSS = format;
    }

    public void setSdfYYYYMDDD(SimpleDateFormat format) {
        this.sdfYYYYMDDD = format;
    }

    public void setSHHMMSS(String string) {
        this.sHHMMSS = string;
    }

    public void setSLogDir(String string) {
        this.sLogDir = string;
    }

    public void setSLogName(String string) {
        this.sLogName = string;
    }

    public void setSYYYYMMDD(String string) {
        this.sYYYYMMDD = string;
    }
}

