/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.jmx;

import com.sysmon.WLMonitor.log.ConsoleLogger;
import com.sysmon.WLMonitor.log.Logger;
import com.sysmon.WLMonitor.vo.ServerMBeanDataVO;
import com.sysmon.WLMonitor.vo.WeblogicDomainVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import weblogic.management.Helper;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.runtime.EJBCacheRuntimeMBean;
import weblogic.management.runtime.EJBLockingRuntimeMBean;
import weblogic.management.runtime.EJBPoolRuntimeMBean;
import weblogic.management.runtime.EJBTransactionRuntimeMBean;
import weblogic.management.runtime.ExecuteQueueRuntimeMBean;
import weblogic.management.runtime.ExecuteThread;
import weblogic.management.runtime.JDBCConnectionPoolRuntimeMBean;
import weblogic.management.runtime.JMSRuntimeMBean;
import weblogic.management.runtime.JTARuntimeMBean;
import weblogic.management.runtime.JVMRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.StatefulEJBRuntimeMBean;
import weblogic.management.runtime.StatelessEJBRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;

public class JmxContext {
    WeblogicDomainVO xWeblogicDomainVO = null;
    WeblogicServerVO xWeblogicServerVO = null;
    MBeanHome mbHelperHome = null;
    RemoteMBeanServer mbServer = null;
    MBeanHome mbHome = null;
    RuntimeMBean mbRuntime = null;
    boolean bConnectError = true;
    private JVMRuntimeMBean mbJvmRuntime;
    private ExecuteQueueRuntimeMBean mbExecuteQueueRuntime;
    private ServerRuntimeMBean mbServerRuntime;
    private WebAppComponentRuntimeMBean[] mbWebAppComponentRuntimes;
    private JTARuntimeMBean mbJTARuntime;
    private EJBPoolRuntimeMBean[] mbEJBPoolRuntimes;
    private EJBTransactionRuntimeMBean[] mbEJBTransactionRuntimes;
    private EJBCacheRuntimeMBean[] mbSFSB_EJBCacheRuntimes;
    private EJBLockingRuntimeMBean[] mbSFSB_EJBLockingRuntimes;
    private EJBTransactionRuntimeMBean[] mbSFSB_EJBTransactionRuntimes;
    private JMSRuntimeMBean[] mbJMSRuntimes;
    private JDBCConnectionPoolRuntimeMBean[] mbJDBCConnectionPoolRuntimes;
    private int oldServicedRequestTotalCount = 0;
    Logger logger = Logger.getInstance();

    public JmxContext() {
    }

    public JmxContext(WeblogicDomainVO xWeblogicDomainVO, WeblogicServerVO xWeblogicServerVO) {
        this.xWeblogicDomainVO = xWeblogicDomainVO;
        this.xWeblogicServerVO = xWeblogicServerVO;
    }

    public ServerMBeanDataVO getSample() {
        boolean result = true;
        ServerMBeanDataVO xServerMBeanDataVO = new ServerMBeanDataVO();
        xServerMBeanDataVO.setTime(System.currentTimeMillis());
        if (this.bConnectError && !(result = this.setContext())) {
            return xServerMBeanDataVO;
        }
        try {
            xServerMBeanDataVO.setHeapSizeCurrent((int)this.mbJvmRuntime.getHeapSizeCurrent());
            xServerMBeanDataVO.setHeapFreeCurrent((int)this.mbJvmRuntime.getHeapFreeCurrent());
            if (this.mbExecuteQueueRuntime.getExecuteThreadTotalCount() > 0) {
                xServerMBeanDataVO.setExecuteThreadTotalCount(this.mbExecuteQueueRuntime.getExecuteThreadTotalCount());
                xServerMBeanDataVO.setPendingRequestCurrentCount(this.mbExecuteQueueRuntime.getPendingRequestCurrentCount());
                xServerMBeanDataVO.setServicedRequestTotalCount(this.mbExecuteQueueRuntime.getServicedRequestTotalCount());
                xServerMBeanDataVO.setExecuteThreadCurrentIdleCount(this.mbExecuteQueueRuntime.getExecuteThreadCurrentIdleCount());
                ExecuteThread[] executeThreads = new ExecuteThread[this.mbExecuteQueueRuntime.getExecuteThreadTotalCount()];
                executeThreads = this.mbExecuteQueueRuntime.getExecuteThreads();
                xServerMBeanDataVO.setThreadCnt(this.mbExecuteQueueRuntime.getExecuteThreadTotalCount());
                int yy = 0;
                while (yy < this.mbExecuteQueueRuntime.getExecuteThreadTotalCount()) {
                    if (!executeThreads[yy].getName().equals("Read Multicast Msg Fragment")) {
                        xServerMBeanDataVO.setThreadNo(yy, executeThreads[yy].getName());
                        xServerMBeanDataVO.setThreadServicedRequestTotalCount(yy, executeThreads[yy].getServicedRequestTotalCount());
                        xServerMBeanDataVO.setThreadCurrentRequest(yy, executeThreads[yy].getCurrentRequest());
                        xServerMBeanDataVO.setThreadCurrentRequestStartTime(yy, executeThreads[yy].getCurrentRequestStartTime());
                    }
                    ++yy;
                }
            }
            if (this.oldServicedRequestTotalCount > 0) {
                xServerMBeanDataVO.setRequests(this.mbExecuteQueueRuntime.getServicedRequestTotalCount() - this.oldServicedRequestTotalCount);
                xServerMBeanDataVO.setThroughput(xServerMBeanDataVO.getRequests() / Integer.parseInt(this.xWeblogicDomainVO.getIntervalSec()));
            }
            this.oldServicedRequestTotalCount = this.mbExecuteQueueRuntime.getServicedRequestTotalCount();
            if (this.mbWebAppComponentRuntimes.length > 0) {
                xServerMBeanDataVO.setWebAppCnt(this.mbWebAppComponentRuntimes.length);
                int i = 0;
                while (i < this.mbWebAppComponentRuntimes.length) {
                    if (this.mbWebAppComponentRuntimes[i] != null) {
                        xServerMBeanDataVO.setWebAppName(i, this.mbWebAppComponentRuntimes[i].getName());
                        xServerMBeanDataVO.setOpenSessionsCurrentCounts(i, this.mbWebAppComponentRuntimes[i].getOpenSessionsCurrentCount());
                    }
                    ++i;
                }
            }
            xServerMBeanDataVO.setOpenSocketsCurrentCount(this.mbServerRuntime.getOpenSocketsCurrentCount());
            if (this.mbJDBCConnectionPoolRuntimes.length > 0) {
                xServerMBeanDataVO.setJdbcCnt(this.mbJDBCConnectionPoolRuntimes.length);
                int i = 0;
                while (i < this.mbJDBCConnectionPoolRuntimes.length) {
                    xServerMBeanDataVO.setJdbcName(i, this.mbJDBCConnectionPoolRuntimes[i].getName());
                    xServerMBeanDataVO.setJdbcMaxCapacity(i, this.mbJDBCConnectionPoolRuntimes[i].getMaxCapacity());
                    xServerMBeanDataVO.setJdbcActiveConnectionsCurrentCount(i, this.mbJDBCConnectionPoolRuntimes[i].getActiveConnectionsCurrentCount());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.bConnectError = true;
            xServerMBeanDataVO = new ServerMBeanDataVO();
            xServerMBeanDataVO.setTime(System.currentTimeMillis());
            if (this.xWeblogicServerVO != null) {
                this.logger.printErr("Weblogic Server JMX MBean get error!! : " + e.toString());
            }
            this.logger.printErr(this.xWeblogicServerVO.getServerName(), "Weblogic Server JMX MBean get error!! : " + e.toString());
        }
        return xServerMBeanDataVO;
    }

    public Set getAllServer() {
        return this.mbHelperHome.getMBeansByType("Server");
    }

    public boolean setContext() {
        this.bConnectError = true;
        try {
            ConsoleLogger.printInfo("Connecting to t3://" + this.xWeblogicServerVO.getHostIP() + ":" + this.xWeblogicServerVO.getServerPort() + "  at " + this.xWeblogicServerVO.getServerName() + "  in " + this.xWeblogicDomainVO.getDomainName());
            this.mbHelperHome = Helper.getMBeanHome((String)this.xWeblogicDomainVO.getUserName(), (String)this.xWeblogicDomainVO.getUserPassword(), (String)("t3://" + this.xWeblogicServerVO.getHostIP() + ":" + this.xWeblogicServerVO.getServerPort()), (String)this.xWeblogicServerVO.getServerName());
            this.mbServer = this.mbHelperHome.getMBeanServer();
            this.mbHome = this.mbServer.getMBeanHome();
            ConsoleLogger.printInfo("Connected from t3://" + this.xWeblogicServerVO.getHostIP() + ":" + this.xWeblogicServerVO.getServerPort() + "  at " + this.xWeblogicServerVO.getServerName() + "  in " + this.xWeblogicDomainVO.getDomainName());
            this.mbJvmRuntime = (JVMRuntimeMBean)this.mbHome.getRuntimeMBean(this.xWeblogicServerVO.getServerName(), "JVMRuntime");
            Set setExecuteQueue = this.mbHelperHome.getMBeansByType("ExecuteQueueRuntime");
            int i = 0;
            Iterator it = setExecuteQueue.iterator();
            while (it.hasNext()) {
                this.mbRuntime = (RuntimeMBean)it.next();
                if (this.mbRuntime.getName().indexOf("Default") <= 0) continue;
                this.mbExecuteQueueRuntime = (ExecuteQueueRuntimeMBean)this.mbHome.getRuntimeMBean(this.mbRuntime.getName(), "ExecuteQueueRuntime");
                ++i;
            }
            this.mbServerRuntime = (ServerRuntimeMBean)this.mbHelperHome.getRuntimeMBean(this.xWeblogicServerVO.getServerName(), "ServerRuntime");
            Set setWebAppComponentRuntime = this.mbHelperHome.getMBeansByType("WebAppComponentRuntime");
            this.mbWebAppComponentRuntimes = new WebAppComponentRuntimeMBean[this.getWebAppComponetRuntimeTokenSize(setWebAppComponentRuntime)];
            i = 0;
            Iterator it2 = setWebAppComponentRuntime.iterator();
            while (it2.hasNext()) {
                this.mbRuntime = (WebAppComponentRuntimeMBean)it2.next();
                if (!this.getWebAppComponetRuntimeTypeMatch(this.mbRuntime.getName())) continue;
                this.mbWebAppComponentRuntimes[i] = (WebAppComponentRuntimeMBean)this.mbRuntime;
                ++i;
            }
            this.mbJTARuntime = this.mbServerRuntime.getJTARuntime();
            Set setStatelessEJBRuntime = this.mbHelperHome.getMBeansByType("StatelessEJBRuntime");
            this.mbEJBPoolRuntimes = new EJBPoolRuntimeMBean[setStatelessEJBRuntime.size()];
            this.mbEJBTransactionRuntimes = new EJBTransactionRuntimeMBean[setStatelessEJBRuntime.size()];
            i = 0;
            Iterator it3 = setStatelessEJBRuntime.iterator();
            while (it3.hasNext()) {
                StatelessEJBRuntimeMBean rt = (StatelessEJBRuntimeMBean)it3.next();
                this.mbEJBPoolRuntimes[i] = rt.getPoolRuntime();
                this.mbEJBTransactionRuntimes[i] = rt.getTransactionRuntime();
                ++i;
            }
            Set setStatefulEJBRuntime = this.mbHelperHome.getMBeansByType("StatefulEJBRuntime");
            this.mbSFSB_EJBCacheRuntimes = new EJBCacheRuntimeMBean[setStatefulEJBRuntime.size()];
            this.mbSFSB_EJBLockingRuntimes = new EJBLockingRuntimeMBean[setStatefulEJBRuntime.size()];
            this.mbSFSB_EJBTransactionRuntimes = new EJBTransactionRuntimeMBean[setStatefulEJBRuntime.size()];
            i = 0;
            Iterator it4 = setStatefulEJBRuntime.iterator();
            while (it4.hasNext()) {
                StatefulEJBRuntimeMBean rt = (StatefulEJBRuntimeMBean)it4.next();
                this.mbSFSB_EJBCacheRuntimes[i] = rt.getCacheRuntime();
                this.mbSFSB_EJBLockingRuntimes[i] = rt.getLockingRuntime();
                this.mbSFSB_EJBTransactionRuntimes[i] = rt.getTransactionRuntime();
                ++i;
            }
            Set setJMSRuntime = this.mbHelperHome.getMBeansByType("JMSRuntime");
            this.mbJMSRuntimes = new JMSRuntimeMBean[setJMSRuntime.size()];
            i = 0;
            Iterator it5 = setJMSRuntime.iterator();
            while (it5.hasNext()) {
                this.mbRuntime = (RuntimeMBean)it5.next();
                this.mbJMSRuntimes[i] = (JMSRuntimeMBean)this.mbHome.getRuntimeMBean(this.mbRuntime.getName(), "JMSRuntime");
                ++i;
            }
            Set setJDBCConnectionPoolRuntime = this.mbHelperHome.getMBeansByType("JDBCConnectionPoolRuntime");
            this.mbJDBCConnectionPoolRuntimes = new JDBCConnectionPoolRuntimeMBean[setJDBCConnectionPoolRuntime.size()];
            i = 0;
            Iterator it6 = setJDBCConnectionPoolRuntime.iterator();
            while (it6.hasNext()) {
                this.mbRuntime = (RuntimeMBean)it6.next();
                this.mbJDBCConnectionPoolRuntimes[i] = (JDBCConnectionPoolRuntimeMBean)this.mbHome.getRuntimeMBean(this.mbRuntime.getName(), "JDBCConnectionPoolRuntime");
                ++i;
            }
            this.bConnectError = false;
            if (this.xWeblogicServerVO == null) {
                this.logger.printInfo("Weblogic Server Connected!!");
            } else {
                this.logger.printInfo(this.xWeblogicServerVO.getServerName(), "Weblogic Server Connected!!");
            }
        }
        catch (Exception e) {
            if (this.xWeblogicServerVO == null) {
                this.logger.printErr("Weblogic Server Connect fail!! : " + e.toString());
            } else {
                this.logger.printErr(this.xWeblogicServerVO.getServerName(), "Weblogic Server Connect fail!! : " + e.toString());
            }
            this.bConnectError = true;
            return false;
        }
        return true;
    }

    private int getWebAppComponetRuntimeTokenSize(Set mbTypeSet) {
        RuntimeMBean mbRuntime = null;
        int count = 0;
        Iterator it = mbTypeSet.iterator();
        while (it.hasNext()) {
            mbRuntime = (RuntimeMBean)it.next();
            String Name = mbRuntime.getName();
            if (Name.indexOf("console_console") != -1 || Name.indexOf("uddiexplorer") != -1 || Name.indexOf("wl_management") != -1 || Name.indexOf("uddi_uddi") != -1) continue;
            ++count;
        }
        return count;
    }

    private int getStringTokenSize(Set mbTypeSet, String str) {
        if (str == null) {
            return mbTypeSet.size();
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        return st.countTokens();
    }

    private boolean getWebAppComponetRuntimeTypeMatch(String Str) {
        boolean rtn = false;
        if (Str.indexOf("console_console") == -1 && Str.indexOf("uddiexplorer") == -1 && Str.indexOf("wl_management") == -1 && Str.indexOf("uddi_uddi") == -1) {
            rtn = true;
        }
        return rtn;
    }

    private boolean getTypeMatch(String tokenStr, String findStr) {
        if (tokenStr != null) {
            StringTokenizer st = new StringTokenizer(tokenStr, ",");
            while (st.hasMoreElements()) {
                String str = st.nextToken();
                if (findStr.indexOf(str) <= -1) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public MBeanHome getMbHelperHome() {
        return this.mbHelperHome;
    }

    public void setMbHelperHome(MBeanHome mbHelperHome) {
        this.mbHelperHome = mbHelperHome;
    }

    public MBeanHome getMbHome() {
        return this.mbHome;
    }

    public void setMbHome(MBeanHome mbHome) {
        this.mbHome = mbHome;
    }

    public RuntimeMBean getMbRuntime() {
        return this.mbRuntime;
    }

    public void setMbRuntime(RuntimeMBean mbRuntime) {
        this.mbRuntime = mbRuntime;
    }

    public RemoteMBeanServer getMbServer() {
        return this.mbServer;
    }

    public void setMbServer(RemoteMBeanServer mbServer) {
        this.mbServer = mbServer;
    }

    public WeblogicDomainVO getXWeblogicDomainVO() {
        return this.xWeblogicDomainVO;
    }

    public void setXWeblogicDomainVO(WeblogicDomainVO weblogicDomainVO) {
        this.xWeblogicDomainVO = weblogicDomainVO;
    }

    public WeblogicServerVO getXWeblogicServerVO() {
        return this.xWeblogicServerVO;
    }

    public void setXWeblogicServerVO(WeblogicServerVO weblogicServerVO) {
        this.xWeblogicServerVO = weblogicServerVO;
    }
}

