/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.config;

import com.sysmon.WLMonitor.vo.MainVO;
import com.sysmon.WLMonitor.vo.WeblogicDomainListVO;
import com.sysmon.WLMonitor.vo.WeblogicDomainVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.beans.IntrospectionException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.xml.sax.SAXException;

public class Config {
    static Config xConfig;
    File configFile;
    WeblogicDomainListVO weblogicDomainListVO;
    FileReader xmlReader;
    static /* synthetic */ Class class$0;

    public static Config getInstance() {
        if (xConfig == null) {
            xConfig = new Config();
        }
        return xConfig;
    }

    public synchronized WeblogicDomainListVO readConfig() {
        this.configFile = new File(MainVO.getConfigFileName());
        if (!this.configFile.exists()) {
            try {
                this.makeDefaultConfigFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.readConfigFile();
        return this.weblogicDomainListVO;
    }

    void readConfigFile() {
        try {
            this.xmlReader = new FileReader(MainVO.getConfigFileName());
            BeanReader beanReader = new BeanReader();
            beanReader.getXMLIntrospector().setAttributesForPrimitives(false);
            beanReader.setMatchIDs(false);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sysmon.WLMonitor.vo.WeblogicDomainListVO");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            beanReader.registerBeanClass("WLMonitor", (Class)clazz);
            this.weblogicDomainListVO = (WeblogicDomainListVO)beanReader.parse((Reader)this.xmlReader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    void makeDefaultConfigFile() throws Exception {
        this.weblogicDomainListVO = new WeblogicDomainListVO();
        StringWriter outputWriter = new StringWriter();
        outputWriter.write("<?xml version='1.0' ?>");
        BeanWriter beanWriter = new BeanWriter((Writer)outputWriter);
        beanWriter.getXMLIntrospector().setAttributesForPrimitives(false);
        beanWriter.setWriteIDs(false);
        beanWriter.enablePrettyPrint();
        WeblogicServerVO server1 = new WeblogicServerVO();
        server1.setServerName("myserver");
        WeblogicDomainVO domain1 = new WeblogicDomainVO();
        domain1.addWeblogicServer(server1);
        this.weblogicDomainListVO.addWeblogicDomain(domain1);
        try {
            beanWriter.write("WLMonitor", (Object)this.weblogicDomainListVO);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        this.saveConfigStringToFile(outputWriter.toString());
    }

    public void saveConfigFile(String configFileName) throws Exception {
        MainVO.setConfigFileName(configFileName);
        this.saveConfigFile();
    }

    public void saveConfigFile() throws Exception {
        StringWriter outputWriter = new StringWriter();
        outputWriter.write("<?xml version='1.0' ?>");
        BeanWriter beanWriter = new BeanWriter((Writer)outputWriter);
        beanWriter.getXMLIntrospector().setAttributesForPrimitives(false);
        beanWriter.setWriteIDs(false);
        beanWriter.enablePrettyPrint();
        beanWriter.write("WLMonitor", (Object)this.weblogicDomainListVO);
        this.saveConfigStringToFile(outputWriter.toString());
    }

    void saveConfigStringToFile(String config) throws Exception {
        try {
            FileWriter fw = new FileWriter(MainVO.getConfigFileName(), false);
            PrintWriter pwWriter = new PrintWriter((Writer)new BufferedWriter(fw), true);
            pwWriter.println(config);
            pwWriter.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("make default config file fail!!");
        }
    }

    public WeblogicDomainListVO getWeblogicDomainListVO() {
        return this.weblogicDomainListVO;
    }

    public void setWeblogicDomainListVO(WeblogicDomainListVO weblogicDomainListVO) {
        this.weblogicDomainListVO = weblogicDomainListVO;
    }

    public static Config getXConfig() {
        return xConfig;
    }

    public static void setXConfig(Config config) {
        xConfig = config;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public FileReader getXmlReader() {
        return this.xmlReader;
    }

    public void setXmlReader(FileReader xmlReader) {
        this.xmlReader = xmlReader;
    }
}

