/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.UI.popup;

import com.sysmon.WLMonitor.UI.popup.AddDomainDialog;
import com.sysmon.WLMonitor.config.Config;
import com.sysmon.WLMonitor.main.MainFrame;
import com.sysmon.WLMonitor.vo.MainVO;
import com.sysmon.WLMonitor.vo.WeblogicDomainListVO;
import com.sysmon.WLMonitor.vo.WeblogicDomainVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ConfigDialog
extends JDialog {
    static ConfigDialog xConfigDialog;
    Container CPane;
    JFrame owner;
    Config xConfig = Config.getInstance();
    WeblogicDomainListVO currentWeblogicDomainListVO = null;
    ArrayList currentDomainArrayList = null;
    WeblogicDomainVO currentWeblogicDomainVO = null;
    ArrayList currentWeblogicServerArrayList = null;
    WeblogicServerVO currentWeblogicServerVO = null;
    JList domainList;
    JList serverList;
    JList selectServerList;
    DefaultListModel domainListModel;
    DefaultListModel serverListModel;
    DefaultListModel selectServerListModel;
    JScrollPane domainScroll;
    JScrollPane serverScroll;
    JScrollPane selectServerScroll;
    TitledBorder xTitledBorder;
    Button domainInsertButton = new Button("\ub3c4\uba54\uc778\ucd94\uac00");
    Button domainDeleteButton = new Button("\ub3c4\uba54\uc778\uc0ad\uc81c");
    Button selectServerExecuteButton = new Button("\ubaa8\ub2c8\ud130\ub9c1\uc218\ud589");
    Button serverSaveButton = new Button("\uc800\uc7a5");
    Button serverOpenButton = new Button("\uc5f4\uae30");
    Button closeButton = new Button("\ub2eb\uae30");
    Button addSelectServerButton = new Button(">");
    Button addSelectServerAllButton = new Button(">>");
    Button removeSelectServerButton = new Button("<");
    Button removeSelectServerAllButton = new Button("<<");
    JTextField userNameText = new JTextField();
    JTextField serverTitleText = new JTextField();
    JTextField serverNameText = new JTextField();
    JTextField serverIPText = new JTextField();
    JTextField serverPortText = new JTextField();
    String[] serverIntervalItem = new String[]{"5", "10", "20", "30"};
    JComboBox serverIntervalComboBox = new JComboBox<String>(this.serverIntervalItem);
    String[] serverHeapUtilizationItem = new String[]{"90", "80", "70", "60", "0"};
    JComboBox serverHeapUtilizationComboBox = new JComboBox<String>(this.serverHeapUtilizationItem);
    String[] serverExecuteThreadUtilizationItem = new String[]{"90", "80", "70", "60", "0"};
    JComboBox serverExecuteThreadUtilizationComboBox = new JComboBox<String>(this.serverExecuteThreadUtilizationItem);
    String[] serverPendingRequestsItem = new String[]{"5", "10", "50", "100", "0"};
    JComboBox serverPendingRequestsComboBox = new JComboBox<String>(this.serverPendingRequestsItem);
    String[] serverThroughputItem = new String[]{"20", "50", "100", "200", "0"};
    JComboBox serverThroughputComboBox = new JComboBox<String>(this.serverThroughputItem);
    String[] serverExecuteThreadElapsedLimitSecondItem = new String[]{"100", "200", "300", "400", "500", "1000", "0"};
    JComboBox serverExecuteThreadElapsedLimitSecondComboBox = new JComboBox<String>(this.serverExecuteThreadElapsedLimitSecondItem);
    String[] serverOpenSocketsItem = new String[]{"50", "100", "200", "300", "400", "500"};
    JComboBox serverOpenSocketsComboBox = new JComboBox<String>(this.serverOpenSocketsItem);
    String[] serverJDBCConnectionUtilizationItem = new String[]{"90", "80", "70", "60", "0"};
    JComboBox serverJDBCConnectionUtilizationComboBox = new JComboBox<String>(this.serverJDBCConnectionUtilizationItem);
    Font defaultFont;
    FontMetrics defaultFontMetrics;
    static final int DIALOG_WIDTH = 566;
    static final int DIALOG_HEIGHT = 450;

    public static ConfigDialog getInstance() {
        if (xConfigDialog == null) {
            xConfigDialog = new ConfigDialog(MainFrame.getInstance(), true);
        }
        return xConfigDialog;
    }

    public static ConfigDialog getNewInstance() {
        xConfigDialog = new ConfigDialog(MainFrame.getInstance(), true);
        return xConfigDialog;
    }

    public ConfigDialog(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.owner = owner;
        this.setup();
    }

    void setDialogTitle() {
        this.setTitle("\ud658\uacbd\uc124\uc815 :: " + MainVO.getConfigFileName());
    }

    void setup() {
        this.setDialogTitle();
        this.CPane = this.getContentPane();
        this.CPane.setLayout(null);
        this.defaultFont = this.getFont();
        this.defaultFontMetrics = this.getFontMetrics(this.defaultFont);
        this.setSize(566, 450);
        this.setResizable(false);
        Rectangle ownerBounds = this.owner.getBounds();
        Dimension dialogSize = this.getSize();
        this.setLocation((int)(ownerBounds.getCenterX() - (double)(dialogSize.width / 2)), (int)(ownerBounds.getCenterY() - (double)(dialogSize.height / 2)));
        this.domainListMake();
        this.serverListMake();
        this.selectServerListMake();
        this.domainItemMake();
        this.serverItemMake();
        this.buttonMake();
        Config.getInstance().readConfig();
        this.reloadConfig(true);
        this.addListener();
    }

    public void reloadConfig(boolean configRead) {
        if (configRead) {
            this.currentWeblogicDomainListVO = this.xConfig.readConfig();
        }
        this.currentDomainArrayList = this.currentWeblogicDomainListVO.getWeblogicDomains();
        this.domainListModel.removeAllElements();
        this.clearValue();
        this.setDomainListItem();
    }

    void setDomainListItem() {
        this.domainListModel.removeAllElements();
        int i = 0;
        while (i < this.currentDomainArrayList.size()) {
            WeblogicDomainVO xWeblogicDomainVO = (WeblogicDomainVO)this.currentDomainArrayList.get(i);
            this.domainListModel.addElement(xWeblogicDomainVO.getDomainName());
            if (xWeblogicDomainVO.isSelected()) {
                this.domainList.setSelectedIndex(i);
                this.setServerListItem();
            }
            ++i;
        }
        this.domainListModel.getSize();
    }

    void domainListMake() {
        this.domainList = new JList();
        this.domainListModel = new DefaultListModel();
        this.domainList.setModel(this.domainListModel);
        this.domainList.setSelectionMode(1);
        this.domainList.setToolTipText("\uc6f9\ub85c\uc9c1 \ub3c4\uba54\uc778 \ub9ac\uc2a4\ud2b8");
        this.domainScroll = new JScrollPane(this.domainList);
        this.xTitledBorder = new TitledBorder("\ub3c4\uba54\uc778 \ub9ac\uc2a4\ud2b8");
        this.xTitledBorder.setTitlePosition(2);
        this.domainScroll.setBorder(new TitledBorder(this.xTitledBorder));
        this.domainScroll.setBounds(5, 5, 165, 130);
        this.CPane.add(this.domainScroll);
    }

    void domainItemMake() {
        int xTextPos1 = 7;
        int yPos = 135;
        int yHeight = 25;
        int yStep = 45;
        int xWidth = 160;
        JLabel userNameLabel = new JLabel("\uacc4\uc815\uba85");
        userNameLabel.setBounds(xTextPos1, yPos, xWidth, yHeight);
        this.userNameText.setBounds(xTextPos1, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.userNameText.setEnabled(false);
        this.CPane.add(userNameLabel);
        this.CPane.add(this.userNameText);
        JLabel serverIntervalLabel = new JLabel("\ubaa8\ub2c8\ud130\ub9c1\uc8fc\uae30(\ucd08)");
        serverIntervalLabel.setBounds(xTextPos1, yPos += yStep, xWidth, yHeight);
        this.serverIntervalComboBox.setBounds(xTextPos1, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverIntervalComboBox.setToolTipText("\uc6f9\ub85c\uc9c1 \uc11c\ubc84\uc5d0\uc11c \uc815\ubcf4\ub97c \uc218\uc9d1\ud558\ub294 \uc8fc\uae30 \uc120\ud0dd");
        this.CPane.add(serverIntervalLabel);
        this.CPane.add(this.serverIntervalComboBox);
    }

    void serverListMake() {
        this.serverList = new JList();
        this.serverListModel = new DefaultListModel();
        this.serverList.setModel(this.serverListModel);
        this.domainList.setSelectionMode(1);
        this.serverList.setToolTipText("\uc6f9\ub85c\uc9c1 \uc11c\ubc84 \ub9ac\uc2a4\ud2b8(\ub354\ube14\ud074\ub9ad \uac00\ub2a5)");
        this.serverScroll = new JScrollPane(this.serverList);
        this.xTitledBorder = new TitledBorder("\uc11c\ubc84 \ub9ac\uc2a4\ud2b8");
        this.xTitledBorder.setTitlePosition(2);
        this.serverScroll.setBorder(this.xTitledBorder);
        this.serverScroll.setBounds(170, 5, 165, 130);
        this.CPane.add(this.serverScroll);
    }

    void serverItemMake() {
        int xTextPos0 = 7;
        int xTextPos1 = 7;
        int xTextPos2 = 172;
        int yPos = 135;
        int yHeight = 25;
        int yStep = 45;
        int xStep = 7;
        int xPos = xTextPos2;
        int xWidth = 375;
        JLabel serverTitleLabel = new JLabel("\uc11c\ubc84\uc124\uba85");
        serverTitleLabel.setBounds(xPos, yPos, xWidth, yHeight);
        this.serverTitleText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverNameText.setToolTipText("\uc6f9\ub85c\uc9c1 \uc11c\ubc84\uc5d0 \ub300\ud55c \uc124\uba85\uc73c\ub85c \uc708\ub3c4\uc6b0 \ud0c0\uc774\ud2c0\uc5d0 Display\ub428");
        this.serverNameText.setEnabled(false);
        this.CPane.add(serverTitleLabel);
        this.CPane.add(this.serverTitleText);
        xWidth = 160;
        xPos = xTextPos0 + xWidth + xStep;
        JLabel serverNameLabel = new JLabel("\uc11c\ubc84\uba85");
        serverNameLabel.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.serverNameText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverNameText.setToolTipText("\uc6f9\ub85c\uc9c1 \ucf58\uc194\uc5d0\uc11c \ub4f1\ub85d\ud55c \uc11c\ubc84\uba85\uacfc \ub3d9\uc77c\ud558\uac8c \uc785\ub825\ud574\uc57c\ud568");
        this.CPane.add(serverNameLabel);
        this.CPane.add(this.serverNameText);
        xPos += xWidth + xStep;
        xWidth = 101;
        JLabel serverIPLabel = new JLabel("IP");
        serverIPLabel.setBounds(xPos, yPos, xWidth, yHeight);
        this.serverIPText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverIPText.setToolTipText("\uc6f9\ub85c\uc9c1 \uc11c\ubc84 IP \uc785\ub825");
        this.CPane.add(serverIPLabel);
        this.CPane.add(this.serverIPText);
        xPos += xWidth + xStep;
        xWidth = 98;
        JLabel serverPortLabel = new JLabel("Port");
        serverPortLabel.setBounds(xPos, yPos, xWidth, yHeight);
        this.serverPortText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverPortText.setToolTipText("\uc6f9\ub85c\uc9c1 \uc11c\ubc84 Port \uc785\ub825, \ubc29\ud654\ubcbd \uc124\uc815 \ud655\uc778 \ud544\uc694");
        this.serverPortText.setEnabled(false);
        this.CPane.add(serverPortLabel);
        this.CPane.add(this.serverPortText);
        xPos = xTextPos1;
        xWidth = 160;
        JLabel serverHeapUtilizationLabel = new JLabel("Heap\uba54\ubaa8\ub9ac \uc0ac\uc6a9\ub960");
        serverHeapUtilizationLabel.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.serverHeapUtilizationComboBox.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverHeapUtilizationComboBox.setToolTipText("Heap\uba54\ubaa8\ub9ac \uc0ac\uc6a9\ub960\uc5d0 \ub300\ud55c \uc784\uacc4\uce58 \uc124\uc815, '0'\uc774\uba74 \uc784\uacc4\uce58 \uc124\uc815 \uc548\ud568");
        this.CPane.add(serverHeapUtilizationLabel);
        this.CPane.add(this.serverHeapUtilizationComboBox);
        JLabel serverJDBCConnectionUtilizationLabel = new JLabel("JDBC \ucee4\ub125\uc158\ud480 \uc0ac\uc6a9\ub960");
        serverJDBCConnectionUtilizationLabel.setBounds(xPos += xWidth + xStep, yPos, xWidth, yHeight);
        this.serverJDBCConnectionUtilizationComboBox.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverJDBCConnectionUtilizationComboBox.setToolTipText("JDBC \ucee4\ub125\uc158\ud480 \uc0ac\uc6a9\ub960\uc5d0 \ub300\ud55c  \uc784\uacc4\uce58 \uc124\uc815, '0'\uc774\uba74 \uc784\uacc4\uce58 \uc124\uc815 \uc548\ud568");
        this.CPane.add(serverJDBCConnectionUtilizationLabel);
        this.CPane.add(this.serverJDBCConnectionUtilizationComboBox);
        xPos = xTextPos1;
        JLabel serverExecuteThreadUtilizationLabel = new JLabel("\uc2a4\ub808\ub4dc \uc0ac\uc6a9\ub960");
        serverExecuteThreadUtilizationLabel.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.serverExecuteThreadUtilizationComboBox.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverExecuteThreadUtilizationComboBox.setToolTipText("Heap\uba54\ubaa8\ub9ac \uc0ac\uc6a9\ub960\uc5d0 \ub300\ud55c \uc784\uacc4\uce58 \uc124\uc815, '0'\uc774\uba74 \uc784\uacc4\uce58 \uc124\uc815 \uc548\ud568");
        this.CPane.add(serverExecuteThreadUtilizationLabel);
        this.CPane.add(this.serverExecuteThreadUtilizationComboBox);
        JLabel serverExecuteThreadElapsedLimitSecondLabel = new JLabel("\uc2a4\ub808\ub4dc\uc218\ud589\uc81c\ud55c(\ucd08)");
        serverExecuteThreadElapsedLimitSecondLabel.setBounds(xPos += xWidth + xStep, yPos, xWidth, yHeight);
        this.serverExecuteThreadElapsedLimitSecondComboBox.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverExecuteThreadElapsedLimitSecondComboBox.setToolTipText("\uc2a4\ub808\ub4dc \uc218\ud589 \uc2dc\uac04\uc5d0 \ub300\ud55c \uc784\uacc4\uce58 \uc124\uc815, '0'\uc774\uba74 \uc784\uacc4\uce58 \uc124\uc815 \uc548\ud568");
        this.CPane.add(serverExecuteThreadElapsedLimitSecondLabel);
        this.CPane.add(this.serverExecuteThreadElapsedLimitSecondComboBox);
        xPos = xTextPos1;
        JLabel serverPendingRequestsLabel = new JLabel("\ucc98\ub9ac\ub300\uae30\uac74\uc218");
        serverPendingRequestsLabel.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.serverPendingRequestsComboBox.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverPendingRequestsComboBox.setToolTipText("Idle \uc2a4\ub808\ub4dc\uac00 \uc5c6\uc5b4 \uc694\uccad\uac74\uc5d0 \ub300\ud55c \ub300\uae30 \ubc1c\uc0dd \uac74\uc218\uc5d0 \ub300\ud55c  \uc784\uacc4\uce58 \uc124\uc815, '0'\uc774\uba74 \uc784\uacc4\uce58 \uc124\uc815 \uc548\ud568");
        this.CPane.add(serverPendingRequestsLabel);
        this.CPane.add(this.serverPendingRequestsComboBox);
        JLabel serverOpenSocketsLabel = new JLabel("\uc624\ud508 \uc18c\ucf13\uc218");
        serverOpenSocketsLabel.setBounds(xPos += xWidth + xStep, yPos, xWidth, yHeight);
        this.serverOpenSocketsComboBox.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverOpenSocketsComboBox.setToolTipText("\ud074\ub77c\uc774\uc5b8\ud2b8\uc5d0\uc11c \uc6f9\ub85c\uc9c1 \uc11c\ubc84\ub85c \uc811\uc18d\ud55c \uc18c\ucf13 \uc218\uc5d0 \ub300\ud55c \uc784\uacc4\uce58 \uc124\uc815, '0'\uc774\uba74 \uc784\uacc4\uce58 \uc124\uc815 \uc548\ud568");
        this.CPane.add(serverOpenSocketsLabel);
        this.CPane.add(this.serverOpenSocketsComboBox);
        xPos = xTextPos1;
        JLabel serverThroughputLabel = new JLabel("Throughput");
        serverThroughputLabel.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.serverThroughputComboBox.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverThroughputComboBox.setToolTipText("\ucd08\ub2f9 \ucc98\ub9ac \uac74\uc218\uc5d0 \ub300\ud55c  \uc784\uacc4\uce58 \uc124\uc815, '0'\uc774\uba74 \uc784\uacc4\uce58 \uc124\uc815 \uc548\ud568");
        this.CPane.add(serverThroughputLabel);
        this.CPane.add(this.serverThroughputComboBox);
    }

    void selectServerListMake() {
        this.selectServerList = new JList();
        this.selectServerListModel = new DefaultListModel();
        this.selectServerList.setModel(this.selectServerListModel);
        this.selectServerList.setToolTipText("\ubaa8\ub2c8\ud130\ub9c1 \ub300\uc0c1 \uc11c\ubc84 \ub9ac\uc2a4\ud2b8(\ub2e4\uc911\uc120\ud0dd,\ub354\ube14\ud074\ub9ad \uac00\ub2a5");
        this.selectServerScroll = new JScrollPane(this.selectServerList);
        this.xTitledBorder = new TitledBorder("\ubaa8\ub2c8\ud130\ub9c1  \uc11c\ubc84 \ub9ac\uc2a4\ud2b8");
        this.xTitledBorder.setTitlePosition(2);
        this.selectServerScroll.setBorder(this.xTitledBorder);
        this.selectServerScroll.setBounds(386, 5, 165, 130);
        this.CPane.add(this.selectServerScroll);
        this.addSelectServerButton.setBounds(335, 13, 50, 30);
        this.removeSelectServerButton.setBounds(335, 43, 50, 30);
        this.addSelectServerAllButton.setBounds(335, 73, 50, 30);
        this.removeSelectServerAllButton.setBounds(335, 103, 50, 30);
        this.CPane.add(this.addSelectServerButton);
        this.CPane.add(this.removeSelectServerButton);
        this.CPane.add(this.addSelectServerAllButton);
        this.CPane.add(this.removeSelectServerAllButton);
    }

    void buttonMake() {
        this.domainInsertButton.setActionCommand("domainInsertButton");
        this.domainDeleteButton.setActionCommand("domainDeleteButton");
        this.serverSaveButton.setActionCommand("serverSaveButton");
        this.serverOpenButton.setActionCommand("serverOpenButton");
        this.selectServerExecuteButton.setActionCommand("selectServerExecuteButton");
        this.closeButton.setActionCommand("closeButton");
        int xTextPos0 = 342;
        int yPos = 278;
        int yHeight = 35;
        int yStep = 45;
        int xStep = 7;
        int xWidth = 101;
        int xPos = xTextPos0;
        this.domainInsertButton.setBounds(xPos, yPos, xWidth, yHeight);
        this.domainDeleteButton.setBounds(xPos += xWidth + xStep, yPos, xWidth, yHeight);
        xPos = xTextPos0;
        this.serverSaveButton.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.serverOpenButton.setBounds(xPos += xWidth + xStep, yPos, xWidth, yHeight);
        this.closeButton.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.CPane.add(this.domainInsertButton);
        this.CPane.add(this.domainDeleteButton);
        this.CPane.add(this.serverSaveButton);
        this.CPane.add(this.serverOpenButton);
        this.CPane.add(this.closeButton);
    }

    void displayDomainInfo() {
        this.userNameText.setText(this.currentWeblogicDomainVO.getUserName());
        this.serverIntervalComboBox.setSelectedItem(this.currentWeblogicDomainVO.getIntervalSec());
    }

    void displayServerInfo(String serverName) {
        WeblogicServerVO xWeblogicServerVO = this.currentWeblogicServerVO;
        this.serverTitleText.setText(xWeblogicServerVO.getServerDescription());
        this.serverNameText.setText(xWeblogicServerVO.getServerName());
        this.serverIPText.setText(xWeblogicServerVO.getHostIP());
        this.serverPortText.setText(xWeblogicServerVO.getServerPort());
        this.serverIntervalComboBox.setSelectedItem(this.currentWeblogicDomainVO.getIntervalSec());
        this.serverHeapUtilizationComboBox.setSelectedItem(xWeblogicServerVO.getHeapUtilization());
        this.serverExecuteThreadUtilizationComboBox.setSelectedItem(xWeblogicServerVO.getExecuteThreadUtilization());
        this.serverPendingRequestsComboBox.setSelectedItem(xWeblogicServerVO.getPendingRequests());
        this.serverThroughputComboBox.setSelectedItem(xWeblogicServerVO.getThroughput());
        this.serverExecuteThreadElapsedLimitSecondComboBox.setSelectedItem(xWeblogicServerVO.getExecuteThreadElapsedLimitSecond());
        this.serverOpenSocketsComboBox.setSelectedItem(xWeblogicServerVO.getOpenSocketsCurrentCount());
        this.serverJDBCConnectionUtilizationComboBox.setSelectedItem(xWeblogicServerVO.getJDBCConnectionUtilization());
    }

    void setServerListItem() {
        String domainName = null;
        domainName = (String)this.domainList.getSelectedValue();
        WeblogicDomainVO xWeblogicDomainVO = null;
        WeblogicServerVO xWeblogicServerVO = null;
        this.serverListModel.removeAllElements();
        this.selectServerListModel.removeAllElements();
        this.clearValue();
        if (this.currentDomainArrayList.size() > 0) {
            int i = 0;
            while (i < this.currentDomainArrayList.size()) {
                xWeblogicDomainVO = (WeblogicDomainVO)this.currentDomainArrayList.get(i);
                if (xWeblogicDomainVO.getDomainName().equals(domainName)) break;
                ++i;
            }
            this.currentWeblogicDomainVO = xWeblogicDomainVO;
            this.currentWeblogicServerArrayList = this.currentWeblogicDomainVO.getWeblogicServers();
            this.currentWeblogicServerVO = null;
            i = 0;
            while (i < this.currentWeblogicServerArrayList.size()) {
                xWeblogicServerVO = (WeblogicServerVO)this.currentWeblogicServerArrayList.get(i);
                this.serverListModel.addElement(xWeblogicServerVO.getServerName());
                if (xWeblogicServerVO.isSelected()) {
                    this.serverList.setSelectedIndex(i);
                    this.setSelectedServerItem(xWeblogicServerVO.getServerName());
                }
                if (xWeblogicServerVO.isSelectedMonitoring()) {
                    this.addSelectedServerList(xWeblogicServerVO.getServerName());
                }
                ++i;
            }
            this.displayDomainInfo();
        }
    }

    void setSelectedServerItem(String serverName) {
        WeblogicServerVO xWeblogicServerVO = null;
        if (this.currentWeblogicServerVO != null) {
            this.moveServerItemTextToVO();
        }
        int i = 0;
        while (i < this.currentWeblogicServerArrayList.size()) {
            xWeblogicServerVO = (WeblogicServerVO)this.currentWeblogicServerArrayList.get(i);
            if (xWeblogicServerVO.getServerName().equals(serverName)) {
                this.currentWeblogicServerVO = xWeblogicServerVO;
            }
            ++i;
        }
        this.displayServerInfo(serverName);
    }

    void addListener() {
        selectedServerListAddRemove xSelectedServerListAddRemove = new selectedServerListAddRemove();
        this.removeSelectServerButton.addActionListener(xSelectedServerListAddRemove);
        this.removeSelectServerAllButton.addActionListener(xSelectedServerListAddRemove);
        this.addSelectServerButton.addActionListener(xSelectedServerListAddRemove);
        this.addSelectServerAllButton.addActionListener(xSelectedServerListAddRemove);
        this.domainList.addListSelectionListener(new domainListSelectedListener());
        this.serverList.addListSelectionListener(new serverListSelectedListener());
        buttonActionListener xButtonActionListener = new buttonActionListener();
        this.domainInsertButton.addActionListener(xButtonActionListener);
        this.serverSaveButton.addActionListener(xButtonActionListener);
        this.serverOpenButton.addActionListener(xButtonActionListener);
        this.domainDeleteButton.addActionListener(xButtonActionListener);
        this.selectServerExecuteButton.addActionListener(xButtonActionListener);
        this.closeButton.addActionListener(xButtonActionListener);
        this.serverList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                if (ev.getClickCount() == 2) {
                    ConfigDialog.this.addSelectedServerList();
                }
            }
        });
        this.selectServerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                if (ev.getClickCount() == 2) {
                    ConfigDialog.this.removeSelectedServerList();
                }
            }
        });
    }

    void addSelectedServerListAll() {
        int skipCnt = 0;
        skipCnt = 0;
        int i = 0;
        while (i < this.serverListModel.getSize()) {
            skipCnt += this.addSelectedServerList((String)this.serverListModel.get(i));
            ++i;
        }
        if (skipCnt > 0) {
            JOptionPane.showMessageDialog(xConfigDialog, "\uc774\ubbf8 \uc120\ud0dd\ub41c " + skipCnt + "\uac1c\ub294 Skip \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    void addSelectedServerList() {
        Object[] serverListObjects = this.serverList.getSelectedValues();
        int skipCnt = 0;
        skipCnt = 0;
        int i = 0;
        while (i < serverListObjects.length) {
            skipCnt += this.addSelectedServerList((String)serverListObjects[i]);
            ++i;
        }
        if (skipCnt > 0) {
            JOptionPane.showMessageDialog(xConfigDialog, "\uc774\ubbf8 \uc120\ud0dd\ub41c " + skipCnt + "\uac1c\ub294 Skip \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    int addSelectedServerList(String serverName) {
        int skipCnt = 0;
        if (this.selectServerListModel.getSize() == 0) {
            this.selectServerListModel.addElement(serverName);
            return 0;
        }
        int size = this.selectServerListModel.getSize();
        int j = 0;
        while (j < size) {
            String selectServer = (String)this.selectServerListModel.get(j);
            if (selectServer.equals(serverName)) {
                ++skipCnt;
            }
            ++j;
        }
        if (skipCnt == 0) {
            this.selectServerListModel.addElement(serverName);
        }
        return skipCnt;
    }

    void removeSelectedServerList() {
        Object[] selectedObjects = null;
        selectedObjects = this.selectServerList.getSelectedValues();
        int i = 0;
        while (i < selectedObjects.length) {
            this.selectServerListModel.removeElement((String)selectedObjects[i]);
            ++i;
        }
    }

    void removeSelectedServerListAll() {
        this.selectServerListModel.removeAllElements();
    }

    void moveServerItemTextToVO() {
        if (this.currentWeblogicServerVO != null) {
            this.currentWeblogicServerVO.setServerDescription(this.serverTitleText.getText());
            this.currentWeblogicServerVO.setHostIP(this.serverIPText.getText());
            this.currentWeblogicServerVO.setServerPort(this.serverPortText.getText());
            this.currentWeblogicDomainVO.setIntervalSec((String)this.serverIntervalComboBox.getSelectedItem());
            this.currentWeblogicServerVO.setHeapUtilization((String)this.serverHeapUtilizationComboBox.getSelectedItem());
            this.currentWeblogicServerVO.setExecuteThreadUtilization((String)this.serverExecuteThreadUtilizationComboBox.getSelectedItem());
            this.currentWeblogicServerVO.setPendingRequests((String)this.serverPendingRequestsComboBox.getSelectedItem());
            this.currentWeblogicServerVO.setThroughput((String)this.serverThroughputComboBox.getSelectedItem());
            this.currentWeblogicServerVO.setExecuteThreadElapsedLimitSecond((String)this.serverExecuteThreadElapsedLimitSecondComboBox.getSelectedItem());
            this.currentWeblogicServerVO.setOpenSocketsCurrentCount((String)this.serverOpenSocketsComboBox.getSelectedItem());
            this.currentWeblogicServerVO.setJDBCConnectionUtilization((String)this.serverJDBCConnectionUtilizationComboBox.getSelectedItem());
        }
    }

    String configFileChooser(String path, boolean open) {
        JFileChooser fc = new JFileChooser(path);
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(new File(MainVO.getConfigFileName()));
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".xml") || f.isDirectory();
            }

            public String getDescription() {
                return "WLMonitor XML config Files";
            }
        });
        int returnVal = open ? fc.showOpenDialog(this) : fc.showSaveDialog(this);
        if (returnVal == 0) {
            return fc.getSelectedFile().getAbsoluteFile().getName();
        }
        return null;
    }

    boolean moveSelectedServerToVO() {
        WeblogicServerVO tmpWeblogicServerVO;
        if (this.currentWeblogicDomainVO == null) {
            return false;
        }
        int i = 0;
        while (i < this.currentDomainArrayList.size()) {
            ((WeblogicDomainVO)this.currentDomainArrayList.get(i)).setSelected(false);
            ++i;
        }
        this.currentWeblogicDomainVO.setSelected(true);
        if (this.currentWeblogicServerVO == null) {
            return false;
        }
        i = 0;
        while (i < this.currentWeblogicServerArrayList.size()) {
            tmpWeblogicServerVO = (WeblogicServerVO)this.currentWeblogicServerArrayList.get(i);
            tmpWeblogicServerVO.setSelected(false);
            tmpWeblogicServerVO.setSelectedMonitoring(false);
            ++i;
        }
        this.currentWeblogicServerVO.setSelected(true);
        if (this.selectServerListModel.size() == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.selectServerListModel.size()) {
            String selectServerName = (String)this.selectServerListModel.get(i2);
            int j = 0;
            while (j < this.currentWeblogicServerArrayList.size()) {
                tmpWeblogicServerVO = (WeblogicServerVO)this.currentWeblogicServerArrayList.get(j);
                if (tmpWeblogicServerVO.getServerName().equals(selectServerName)) {
                    tmpWeblogicServerVO.setSelectedMonitoring(true);
                }
                ++j;
            }
            ++i2;
        }
        return true;
    }

    void saveConfig() {
        String configFileName = null;
        if (!this.moveSelectedServerToVO()) {
            JOptionPane.showMessageDialog(xConfigDialog, "\ubaa8\ub2c8\ud130\ub9c1 \ub300\uc0c1 \uc11c\ubc84\uac00 \uc120\ud0dd\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544 \uc800\uc7a5\ud560 \uc218 \uc5c6\uc74d\ub2c8\ub2e4.");
            return;
        }
        configFileName = this.configFileChooser(".", false);
        if (configFileName == null) {
            return;
        }
        if (!configFileName.toLowerCase().endsWith(".xml")) {
            JOptionPane.showMessageDialog(xConfigDialog, "\ud30c\uc77c \ud655\uc7a5\uc790\uac00 xml\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
            return;
        }
        this.moveServerItemTextToVO();
        try {
            Config.getInstance().saveConfigFile(configFileName);
            JOptionPane.showMessageDialog(xConfigDialog, "\ubcc0\uacbd \uc0ac\ud56d\uc774 \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            xConfigDialog.show(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(xConfigDialog, "\uc800\uc7a5\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", "\uc624\ub958", 0);
            e.printStackTrace();
        }
        this.setDialogTitle();
    }

    void openConfig() {
        String configFileName = null;
        configFileName = this.configFileChooser(".", true);
        if (configFileName == null) {
            return;
        }
        MainVO.setConfigFileName(configFileName);
        this.reloadConfig(true);
        this.setDialogTitle();
    }

    void deleteSelectedDomain() {
        String domainName = (String)this.domainList.getSelectedValue();
        int selectedPos = this.domainList.getSelectedIndex();
        if (domainName == null) {
            JOptionPane.showMessageDialog(xConfigDialog, "\uc120\ud0dd\ub41c \ub3c4\uba54\uc778\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        int result = JOptionPane.showConfirmDialog(xConfigDialog, "\uc120\ud0dd\ub41c \ub3c4\uba54\uc778\uc744 \uc815\ub9d0 \uc0ad\uc81c \ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?", "\ud655\uc778", 0, 3);
        if (result == 0) {
            this.currentWeblogicDomainListVO.removeWeblogicDomain(this.currentWeblogicDomainVO);
            this.domainListModel.removeElement(domainName);
            this.clearValue();
        }
        if (this.domainListModel.getSize() > 0) {
            if (selectedPos > 0) {
                this.domainList.setSelectedIndex(selectedPos - 1);
            } else {
                this.domainList.setSelectedIndex(0);
            }
        }
    }

    void clearValue() {
        this.serverListModel.removeAllElements();
        this.selectServerListModel.removeAllElements();
        this.currentWeblogicServerArrayList = null;
        this.currentWeblogicDomainVO = null;
        this.currentWeblogicServerArrayList = null;
        this.currentWeblogicServerVO = null;
        this.serverTitleText.setText("");
        this.serverIPText.setText("");
        this.serverPortText.setText("");
        this.userNameText.setText("");
        this.serverNameText.setText("");
    }

    void addDomain() {
        AddDomainDialog xAddDomainDialog = new AddDomainDialog(xConfigDialog, true);
        xAddDomainDialog.show();
    }

    class domainListSelectedListener
    implements ListSelectionListener {
        domainListSelectedListener() {
        }

        public void valueChanged(ListSelectionEvent ev) {
            ConfigDialog.this.setServerListItem();
        }
    }

    class serverListSelectedListener
    implements ListSelectionListener {
        serverListSelectedListener() {
        }

        public void valueChanged(ListSelectionEvent ev) {
            String serverName = (String)((JList)ev.getSource()).getSelectedValue();
            ConfigDialog.this.setSelectedServerItem(serverName);
        }
    }

    class selectedServerListAddRemove
    implements ActionListener {
        selectedServerListAddRemove() {
        }

        public void actionPerformed(ActionEvent ev) {
            String cmd = ev.getActionCommand();
            if (cmd.equals(">")) {
                ConfigDialog.this.addSelectedServerList();
            } else if (cmd.equals("<")) {
                ConfigDialog.this.removeSelectedServerList();
            } else if (cmd.equals(">>")) {
                ConfigDialog.this.addSelectedServerListAll();
            } else if (cmd.equals("<<")) {
                ConfigDialog.this.removeSelectedServerListAll();
            }
        }
    }

    class buttonActionListener
    implements ActionListener {
        buttonActionListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            String cmd = ev.getActionCommand();
            if (cmd.equals("serverSaveButton")) {
                ConfigDialog.this.saveConfig();
            } else if (cmd.equals("serverOpenButton")) {
                ConfigDialog.this.openConfig();
            } else if (cmd.equals("domainInsertButton")) {
                ConfigDialog.this.addDomain();
            } else if (cmd.equals("domainDeleteButton")) {
                ConfigDialog.this.deleteSelectedDomain();
            } else if (cmd.equals("closeButton")) {
                ConfigDialog.this.show(false);
            }
        }
    }
}

