/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.UI.popup;

import com.sysmon.WLMonitor.UI.popup.ConfigDialog;
import com.sysmon.WLMonitor.config.Config;
import com.sysmon.WLMonitor.jmx.JmxContext;
import com.sysmon.WLMonitor.vo.WeblogicDomainVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import weblogic.management.configuration.ServerMBean;

public class AddDomainDialog
extends JDialog {
    JDialog owner;
    Container CPane;
    Font defaultFont;
    FontMetrics defaultFontMetrics;
    static final int DIALOG_WIDTH = 300;
    static final int DIALOG_HEIGHT = 240;
    JTextField domainNameText = new JTextField("mydomain");
    JTextField userNameText = new JTextField("weblogic");
    JPasswordField userPasswordText = new JPasswordField("weblogic");
    JTextField serverNameText = new JTextField("myserver");
    JTextField serverIPText = new JTextField("localhost");
    JTextField serverPortText = new JTextField("7001");
    Button getDomainInfoButton = new Button("\ub3c4\uba54\uc778\ucd94\uac00");
    JmxContext xSetContext;

    public AddDomainDialog() {
    }

    public AddDomainDialog(JDialog owner, boolean modal) {
        super((Dialog)owner, modal);
        this.owner = owner;
        this.setup();
    }

    void setup() {
        this.setTitle("\ub3c4\uba54\uc778\ucd94\uac00");
        this.CPane = this.getContentPane();
        this.CPane.setLayout(null);
        this.defaultFont = this.getFont();
        this.defaultFontMetrics = this.getFontMetrics(this.defaultFont);
        this.setSize(300, 240);
        this.setResizable(false);
        Rectangle ownerBounds = this.owner.getBounds();
        Dimension dialogSize = this.getSize();
        this.setLocation((int)(ownerBounds.getCenterX() - (double)(dialogSize.width / 2)), (int)(ownerBounds.getCenterY() - (double)(dialogSize.height / 2)));
        this.domainItemMake();
    }

    void domainItemMake() {
        int xTextPos0 = 7;
        int yPos = 7;
        int yHeight = 25;
        int yStep = 45;
        int xStep = 7;
        int xPos = xTextPos0;
        int xWidth = 135;
        JLabel domainTitleLabel = new JLabel("\ub3c4\uba54\uc778\uba85");
        domainTitleLabel.setBounds(xPos, yPos, xWidth, yHeight);
        this.domainNameText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.domainNameText.setToolTipText("\uc6f9\ub85c\uc9c1 \ucf58\uc194\uc5d0\uc11c \ub4f1\ub85d\ud55c \ub3c4\uba54\uc778\uba85\uc744 \uc815\ud655\ud788 \uc785\ub825\ud558\uc138\uc694.");
        this.CPane.add(domainTitleLabel);
        this.CPane.add(this.domainNameText);
        JLabel serverNameLabel = new JLabel("Admin \uc11c\ubc84\uba85");
        serverNameLabel.setBounds(xPos += xWidth + xStep, yPos, xWidth, yHeight);
        this.serverNameText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverNameText.setToolTipText("\uc6f9\ub85c\uc9c1 \ucf58\uc194\uc5d0\uc11c \ub4f1\ub85d\ud55c \uc11c\ubc84\uba85\uc744 \uc815\ud655\uc774 \uc785\ub825\ud558\uc138\uc694.");
        this.CPane.add(serverNameLabel);
        this.CPane.add(this.serverNameText);
        xPos = xTextPos0;
        JLabel userNameTextLabel = new JLabel("\uacc4\uc815\uba85");
        userNameTextLabel.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.userNameText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.userNameText.setToolTipText("\uc6f9\ub85c\uc9c1 \uacc4\uc815\uba85\uc744 \uc815\ud655\ud788 \uc785\ub825\ud558\uc138\uc694.");
        this.CPane.add(userNameTextLabel);
        this.CPane.add(this.userNameText);
        JLabel userPasswordLabel = new JLabel("\ud328\uc2a4\uc6cc\ub4dc");
        userPasswordLabel.setBounds(xPos += xWidth + xStep, yPos, xWidth, yHeight);
        this.userPasswordText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.CPane.add(userPasswordLabel);
        this.CPane.add(this.userPasswordText);
        xPos = xTextPos0;
        JLabel serverIPLabel = new JLabel("IP");
        serverIPLabel.setBounds(xPos, yPos += yStep, xWidth, yHeight);
        this.serverIPText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverIPText.setToolTipText("\uc6f9\ub85c\uc9c1 \uc5b4\ub4dc\ubbfc \uc11c\ubc84 IP \uc785\ub825");
        this.CPane.add(serverIPLabel);
        this.CPane.add(this.serverIPText);
        JLabel serverPortLabel = new JLabel("Port");
        serverPortLabel.setBounds(xPos += xWidth + xStep, yPos, xWidth, yHeight);
        this.serverPortText.setBounds(xPos, yPos + this.defaultFontMetrics.getHeight(), xWidth, yHeight);
        this.serverPortText.setToolTipText("\uc6f9\ub85c\uc9c1 \uc5b4\ub4dc\ubbfc \uc11c\ubc84 Port \uc785\ub825, \ubc29\ud654\ubcbd \uc124\uc815 \ud655\uc778 \ud544\uc694");
        this.CPane.add(serverPortLabel);
        this.CPane.add(this.serverPortText);
        xPos = xTextPos0 + 90;
        this.getDomainInfoButton.setBounds(xPos, yPos += yStep + 15, 100, 25);
        this.getDomainInfoButton.addActionListener(new buttonActionListener());
        this.CPane.add(this.getDomainInfoButton);
    }

    boolean checkValues() {
        boolean result = true;
        if (this.domainNameText.getText() == null || this.domainNameText.getText().equals("")) {
            result = false;
        }
        if (this.userNameText.getText() == null || this.userNameText.getText().equals("")) {
            result = false;
        }
        if (this.userPasswordText.getText() == null || this.userPasswordText.getText().equals("")) {
            result = false;
        }
        if (this.serverNameText.getText() == null || this.serverNameText.getText().equals("")) {
            result = false;
        }
        if (this.serverIPText.getText() == null || this.serverIPText.getText().equals("")) {
            result = false;
        }
        if (this.serverPortText.getText() == null || this.serverPortText.getText().equals("")) {
            result = false;
        }
        return result;
    }

    void getDomainInfo() {
        this.getDomainInfoButton.setEnabled(false);
        WeblogicDomainVO xWeblogicDomainVO = new WeblogicDomainVO();
        WeblogicServerVO xWeblogicServerVO = new WeblogicServerVO();
        xWeblogicDomainVO.setDomainName(this.domainNameText.getText());
        xWeblogicDomainVO.setUserName(this.userNameText.getText());
        xWeblogicDomainVO.setUserPassword(this.userPasswordText.getText());
        xWeblogicServerVO.setServerName(this.serverNameText.getText());
        xWeblogicServerVO.setHostIP(this.serverIPText.getText());
        xWeblogicServerVO.setServerPort(this.serverPortText.getText());
        this.xSetContext = new JmxContext(xWeblogicDomainVO, xWeblogicServerVO);
        if (this.xSetContext.setContext()) {
            Set serverSet = this.xSetContext.getAllServer();
            Iterator it = serverSet.iterator();
            while (it.hasNext()) {
                ServerMBean mbServer = (ServerMBean)it.next();
                WeblogicServerVO xiWeblogicServerVO = new WeblogicServerVO();
                xiWeblogicServerVO.setServerName(mbServer.getName());
                xiWeblogicServerVO.setHostIP(this.serverIPText.getText());
                xiWeblogicServerVO.setServerPort(Integer.toString(mbServer.getListenPort()));
                xWeblogicDomainVO.addWeblogicServer(xiWeblogicServerVO);
            }
            ArrayList arr = Config.getInstance().getWeblogicDomainListVO().getWeblogicDomains();
            Config.getInstance().getWeblogicDomainListVO().addWeblogicDomain(xWeblogicDomainVO);
            arr = Config.getInstance().getWeblogicDomainListVO().getWeblogicDomains();
            ConfigDialog.getInstance().reloadConfig(false);
            JOptionPane.showMessageDialog(this.owner, "\uc6f9\ub85c\uc9c1 \ub3c4\uba54\uc778\uc774 \ucd94\uac00 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            this.disable();
            this.show(false);
        } else {
            this.getDomainInfoButton.setEnabled(true);
            JOptionPane.showMessageDialog(this.owner, "\uc6f9\ub85c\uc9c1 \uc5b4\ub4dc\ubbfc \uc11c\ubc84\uc5d0 \uc811\uc18d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.!!!", "\uc624\ub958", 0);
        }
    }

    class buttonActionListener
    implements ActionListener {
        buttonActionListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            String cmd = ev.getActionCommand();
            if (cmd.equals("\ub3c4\uba54\uc778\ucd94\uac00")) {
                if (AddDomainDialog.this.checkValues()) {
                    AddDomainDialog.this.getDomainInfo();
                } else {
                    JOptionPane.showMessageDialog(AddDomainDialog.this.owner, "\uac12\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc740 \ud56d\ubaa9\uc774 \uc788\uc2b5\ub2c8\ub2e4.", "\uc624\ub958", 0);
                }
            }
        }
    }
}

