/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.UI.graph;

import com.sysmon.WLMonitor.UI.ServerTabItem;
import com.sysmon.WLMonitor.UI.ServerTabPanelThread;
import com.sysmon.WLMonitor.log.Logger;
import com.sysmon.WLMonitor.vo.LineGraphVO;
import com.sysmon.WLMonitor.vo.MainVO;
import com.sysmon.WLMonitor.vo.ServerMBeanDataListVO;
import com.sysmon.WLMonitor.vo.ServerMBeanDataVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JPanel;

public class LineGraphJPanel
extends JPanel {
    static final String HeapUtilizationId = "HeapUtilization";
    static final String ExecuteThreadUtilizationId = "ExecuteThreadUtilization";
    static final String ExecuteThreadTotalId = "ExecuteThreadTotal";
    static final String ExecuteThreadActiveId = "ExecuteThreadActive";
    static final String ExecuteThreadPendingId = "ExecuteThreadPending";
    static final String OpenSessionsId = "OpenSessions";
    static final String OpenSocketsId = "OpenSockets";
    final int GRAPH_SX_MARGIN = 40;
    final int GRAPH_SY_MARGIN = 0;
    final int GRAPH_EX_MARGIN = 30;
    final int GRAPH_EY_MARGIN = 50;
    final long HOUR_LONG_VALUE = 3600000L;
    final long DAY_LONG_VALUE = 43200000L;
    final long TEN_MINUTE_LONG_VALUE = 600000L;
    final int GRAPH_DIVIDE_HOUR_CNT = 6;
    final int GRAPH_DIVIDE_DAY_CNT = 12;
    int graphXDivideCnt = 6;
    int graphYDivideCnt = 5;
    long graphXLongTotalValue;
    long graphXLongDivideValue;
    static boolean dayMode = false;
    ServerTabPanelThread xServerTabPanelThread = ServerTabPanelThread.getInstance();
    ServerMBeanDataListVO[] xServerMBeanDataListVOArray = this.xServerTabPanelThread.getXServerMBeanDataListVO();
    ServerTabItem[] xServerTabItemArray = null;
    int maxValueY = 100;
    int minValueY = 0;
    int yRem;
    long minValueX = 0L;
    long maxValueX = 0L;
    long startValueX = 0L;
    int prevLinePX;
    int prevLinePY;
    int linePX;
    int linePY;
    String title = "";
    Font titleFont;
    Font defaultFont;
    FontMetrics defaultFontMetrics;
    LinkedList graphItem = new LinkedList();
    WeblogicServerVO xWeblogicServerVO = null;
    ServerMBeanDataListVO xServerMBeanDataListVO = null;
    LinkedList xLinkedList;
    LineGraphVO tmpLineGraphVO;
    Logger logger = Logger.getInstance();
    int tabType = 2;
    int canvasX;
    int canvasY;
    int graphPX;
    int graphPY;
    int graphWidth;
    int graphHeight;
    long currentTime;
    int currentHour;
    Date currentDate;
    Thread t;
    static /* synthetic */ Class class$0;

    public LineGraphJPanel() {
        this.title = "noname";
    }

    public LineGraphJPanel(String t) {
        this.title = t;
    }

    public LineGraphJPanel(String t, WeblogicServerVO xWeblogicServerVO, ServerMBeanDataListVO xServerMBeanDataListVO, int sTapType) {
        this.tabType = sTapType;
        this.title = t;
        this.xWeblogicServerVO = xWeblogicServerVO;
        this.xServerMBeanDataListVO = xServerMBeanDataListVO;
    }

    public LineGraphJPanel(String t, WeblogicServerVO xWeblogicServerVO, ServerMBeanDataListVO xServerMBeanDataListVO) {
        this.title = t;
        this.xWeblogicServerVO = xWeblogicServerVO;
        this.xServerMBeanDataListVO = xServerMBeanDataListVO;
    }

    public void repaint(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int valueX;
        this.canvasX = this.getWidth();
        this.canvasY = this.getHeight();
        this.defaultFont = g.getFont();
        this.titleFont = new Font(this.defaultFont.getFontName(), 1, 12);
        g.setFont(this.titleFont);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.canvasX - 1, this.canvasY - 1);
        this.graphPX = 40;
        this.graphPY = this.getFontMetrics(this.titleFont).getHeight() + 0;
        this.graphWidth = this.canvasX - (this.graphPX + 30);
        this.graphHeight = this.canvasY - (this.graphPY + 50);
        g.setColor(Color.BLACK);
        int titleX = (this.graphWidth - this.getFontMetrics(this.titleFont).stringWidth(this.title)) / 2 + this.graphPX;
        g.drawString(this.title, titleX, 12);
        if (dayMode) {
            this.graphXDivideCnt = 12;
            this.graphXLongTotalValue = 43200000L;
            this.graphXLongDivideValue = 3600000L;
        } else {
            this.graphXDivideCnt = 6;
            this.graphXLongTotalValue = 3600000L;
            this.graphXLongDivideValue = 600000L;
        }
        g.setColor(Color.BLACK);
        g.drawRect(this.graphPX, this.graphPY, this.graphWidth, this.graphHeight);
        g.drawLine(this.graphPX - 1, this.graphPY, this.graphPX - 1, this.graphHeight + this.graphPY + 1);
        g.drawLine(this.graphPX - 1, this.graphPY + this.graphHeight + 1, this.graphPX + this.graphWidth, this.graphPY + this.graphHeight + 1);
        g.setColor(Color.RED);
        g.setFont(this.defaultFont);
        this.defaultFontMetrics = this.getFontMetrics(this.defaultFont);
        int yDivideHeight = this.graphHeight / this.graphYDivideCnt;
        int value = this.minValueY;
        int setpY = (this.maxValueY - this.minValueY) / this.graphYDivideCnt;
        int y = this.graphPY + this.graphHeight;
        while (y >= this.graphPY) {
            g.setColor(Color.BLACK);
            g.drawLine(this.graphPX - 5, y, this.graphPX - 1, y);
            valueX = this.defaultFontMetrics.stringWidth(Integer.toString(value));
            g.drawString(Integer.toString(value), this.graphPX - 5 - valueX, y + 5);
            value += setpY;
            if (y > this.graphPY && y < this.graphPY + this.graphHeight) {
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(this.graphPX + 1, y, this.graphPX + this.graphWidth, y);
            }
            y -= yDivideHeight;
        }
        this.yRem = this.graphHeight % yDivideHeight;
        this.maxValueX = this.currentTime = System.currentTimeMillis();
        this.startValueX = this.minValueX = this.currentTime - this.graphXLongTotalValue;
        Date tmpDate = new Date(this.startValueX);
        int xDivideWidth = this.graphWidth / this.graphXDivideCnt;
        valueX = this.graphPX + (int)((this.startValueX - this.minValueX) / this.graphXLongDivideValue) * xDivideWidth;
        long x = this.startValueX;
        while (x <= this.maxValueX) {
            tmpDate = new Date(x);
            StringBuffer timeString = new StringBuffer();
            if (dayMode) {
                timeString.append(Integer.toString(tmpDate.getHours()));
            } else {
                timeString.append(Integer.toString(tmpDate.getHours()));
                timeString.append(":");
                if (tmpDate.getMinutes() < 10) {
                    timeString.append("0");
                }
                timeString.append(Integer.toString(tmpDate.getMinutes()));
            }
            g.setColor(Color.BLACK);
            g.drawLine(valueX, this.graphPY + this.graphHeight, valueX, this.graphPY + this.graphHeight + 5);
            g.drawString(timeString.toString(), valueX - this.defaultFontMetrics.stringWidth(timeString.toString()) / 2, this.graphPY + this.graphHeight + 20);
            valueX += xDivideWidth;
            x += this.graphXLongDivideValue;
        }
        if (this.graphItem.size() == 0) {
            this.setGraphItem();
            if (this.graphItem.size() > 0) {
                this.repaint();
            }
        }
        if (this.graphItem.size() > 0) {
            LineGraphVO xLineGraphVO;
            StringBuffer gTitleAll = new StringBuffer();
            int i = 0;
            while (i < this.graphItem.size()) {
                xLineGraphVO = (LineGraphVO)this.graphItem.get(i);
                gTitleAll.append(xLineGraphVO.getTitle());
                ++i;
            }
            int titleWidth = this.defaultFontMetrics.stringWidth(gTitleAll.toString());
            int titleHeight = this.defaultFontMetrics.getHeight();
            int titlePx = (this.graphWidth - (titleWidth += this.graphItem.size() * 20)) / 2 + this.graphPX;
            int titlePy = this.graphPY + this.graphHeight + 40;
            g.setColor(Color.LIGHT_GRAY);
            g.drawRect(titlePx - 5, titlePy - 14, titleWidth, titleHeight);
            int i2 = 0;
            while (i2 < this.graphItem.size()) {
                xLineGraphVO = (LineGraphVO)this.graphItem.get(i2);
                g.setColor(xLineGraphVO.getGraphColor());
                g.fillRect(titlePx, titlePy - 7, 5, 5);
                g.setColor(Color.BLACK);
                g.drawString(xLineGraphVO.getTitle(), titlePx += 10, titlePy);
                titlePx += 10 + this.defaultFontMetrics.stringWidth(xLineGraphVO.getTitle());
                ++i2;
            }
        }
        this.drawGraph(g);
    }

    public void calcData() {
        boolean limitOverItem = false;
        int limitOverItemCnt = 0;
        if (this.xServerMBeanDataListVO == null) {
            return;
        }
        this.xLinkedList = this.tabType == 2 ? this.xServerMBeanDataListVO.getXLinkedList() : this.xServerMBeanDataListVOArray[1].getXLinkedList();
        ServerMBeanDataVO tmpServerMBeanDataVO = null;
        int valueY = 0;
        limitOverItemCnt = 0;
        tmpServerMBeanDataVO = (ServerMBeanDataVO)this.xLinkedList.getLast();
        int j = 0;
        while (j < this.graphItem.size()) {
            this.tmpLineGraphVO = (LineGraphVO)this.graphItem.get(j);
            try {
                Object obj;
                Method xValueGetMethod;
                if (this.title.equals(OpenSessionsId) || this.title.equals("JDBC Utilization(%)")) {
                    xValueGetMethod = tmpServerMBeanDataVO.getClass().getDeclaredMethod(this.tmpLineGraphVO.getValueGetMethod(), Integer.TYPE);
                    obj = xValueGetMethod.invoke((Object)tmpServerMBeanDataVO, new Integer(j));
                    valueY = (Integer)obj;
                } else if (this.tabType == 2) {
                    xValueGetMethod = tmpServerMBeanDataVO.getClass().getDeclaredMethod(this.tmpLineGraphVO.getValueGetMethod(), null);
                    obj = xValueGetMethod.invoke((Object)tmpServerMBeanDataVO, null);
                    valueY = (Integer)obj;
                } else {
                    tmpServerMBeanDataVO = dayMode ? (ServerMBeanDataVO)this.xServerMBeanDataListVOArray[this.tmpLineGraphVO.getServerPos()].getXLinkedList().getLast() : (ServerMBeanDataVO)this.xServerMBeanDataListVOArray[this.tmpLineGraphVO.getServerPos()].getXLinkedListHour().getLast();
                    xValueGetMethod = tmpServerMBeanDataVO.getClass().getDeclaredMethod(this.tmpLineGraphVO.getValueGetMethod(), null);
                    obj = xValueGetMethod.invoke((Object)tmpServerMBeanDataVO, null);
                    valueY = (Integer)obj;
                }
            }
            catch (Exception e) {
                valueY = 0;
                e.printStackTrace();
            }
            if (valueY > this.maxValueY) {
                this.maxValueY = valueY;
            }
            limitOverItem = false;
            if (this.tmpLineGraphVO.getLimitValueY() != 0) {
                if (this.tmpLineGraphVO.getLimitValueY() > 0 && this.tmpLineGraphVO.getLimitValueY() <= valueY) {
                    limitOverItem = true;
                    if (!this.xWeblogicServerVO.getServerName().equals("Summary")) {
                        this.logger.printErr(this.xWeblogicServerVO.getServerName(), String.valueOf(this.tmpLineGraphVO.getValueGetMethod().replaceFirst("get", "")) + " [ " + valueY + " <= " + this.tmpLineGraphVO.getLimitValueY() + " ]");
                    }
                } else if (this.tmpLineGraphVO.getLimitValueY() < 0 && this.tmpLineGraphVO.getLimitValueY() >= valueY) {
                    limitOverItem = true;
                    if (!this.xWeblogicServerVO.getServerName().equals("Summary")) {
                        this.logger.printErr(this.xWeblogicServerVO.getServerName(), String.valueOf(this.tmpLineGraphVO.getValueGetMethod().replaceFirst("get", "")) + " [ " + valueY + " >= " + this.tmpLineGraphVO.getLimitValueY() + " ]");
                    }
                }
            }
            if (valueY == 0 && this.tmpLineGraphVO.getValueGetMethod().equals("getHeapUtilization")) {
                limitOverItem = true;
            }
            if (limitOverItem) {
                this.tmpLineGraphVO.setLimitOver(true);
                ++limitOverItemCnt;
            }
            ++j;
        }
        if (limitOverItemCnt > 0) {
            MainVO.setError(this.xWeblogicServerVO.getServerName(), 0, true);
        }
    }

    public void drawGraph(Graphics g) {
        boolean limitOverItem = false;
        int limitOverItemCnt = 0;
        if (this.xServerMBeanDataListVO == null) {
            return;
        }
        if (this.xServerMBeanDataListVOArray[1] == null) {
            return;
        }
        this.xLinkedList = dayMode ? (this.tabType == 2 ? this.xServerMBeanDataListVO.getXLinkedList() : this.xServerMBeanDataListVOArray[1].getXLinkedList()) : (this.tabType == 2 ? this.xServerMBeanDataListVO.getXLinkedListHour() : this.xServerMBeanDataListVOArray[1].getXLinkedListHour());
        if (this.xWeblogicServerVO != null) {
            int i = 0;
            while (i < this.graphItem.size()) {
                this.tmpLineGraphVO = (LineGraphVO)this.graphItem.get(i);
                g.setColor(this.tmpLineGraphVO.getGraphColor());
                int limitValue = this.tmpLineGraphVO.getLimitValueY();
                if (limitValue > 0) {
                    this.printXDotLine(g, this.graphPX, this.convertTimeToYPixel(limitValue), this.graphWidth - 4, 5);
                }
                ++i;
            }
        }
        this.linePX = 0;
        this.linePY = 0;
        ServerMBeanDataVO tmpServerMBeanDataVO = null;
        int valueY = 0;
        limitOverItemCnt = 0;
        int i = 0;
        while (i < this.xLinkedList.size()) {
            tmpServerMBeanDataVO = (ServerMBeanDataVO)this.xLinkedList.get(i);
            this.linePX = this.convertTimeToXPixel(tmpServerMBeanDataVO.getTime());
            int j = 0;
            while (j < this.graphItem.size()) {
                block28: {
                    block27: {
                        block26: {
                            this.tmpLineGraphVO = (LineGraphVO)this.graphItem.get(j);
                            try {
                                Object obj;
                                Method xValueGetMethod;
                                if (this.title.equals(OpenSessionsId) || this.title.equals("JDBC Utilization(%)")) {
                                    xValueGetMethod = tmpServerMBeanDataVO.getClass().getDeclaredMethod(this.tmpLineGraphVO.getValueGetMethod(), Integer.TYPE);
                                    obj = xValueGetMethod.invoke((Object)tmpServerMBeanDataVO, new Integer(j));
                                    valueY = (Integer)obj;
                                } else if (this.tabType == 2) {
                                    xValueGetMethod = tmpServerMBeanDataVO.getClass().getDeclaredMethod(this.tmpLineGraphVO.getValueGetMethod(), null);
                                    obj = xValueGetMethod.invoke((Object)tmpServerMBeanDataVO, null);
                                    valueY = (Integer)obj;
                                } else {
                                    tmpServerMBeanDataVO = dayMode ? (ServerMBeanDataVO)this.xServerMBeanDataListVOArray[this.tmpLineGraphVO.getServerPos()].getXLinkedList().get(i) : (ServerMBeanDataVO)this.xServerMBeanDataListVOArray[this.tmpLineGraphVO.getServerPos()].getXLinkedListHour().get(i);
                                    xValueGetMethod = tmpServerMBeanDataVO.getClass().getDeclaredMethod(this.tmpLineGraphVO.getValueGetMethod(), null);
                                    obj = xValueGetMethod.invoke((Object)tmpServerMBeanDataVO, null);
                                    valueY = (Integer)obj;
                                }
                            }
                            catch (Exception e) {
                                valueY = 0;
                                e.printStackTrace();
                            }
                            this.linePY = this.convertTimeToYPixel(valueY);
                            if (i != 0) break block26;
                            this.tmpLineGraphVO.setPrevLinePX(this.linePX);
                            this.tmpLineGraphVO.setPrevLinePY(this.linePY);
                            break block27;
                        }
                        if (this.linePX == this.tmpLineGraphVO.getPrevLinePX() && i != this.xLinkedList.size() - 1) break block28;
                    }
                    g.setColor(this.tmpLineGraphVO.getGraphColor());
                    g.drawLine(this.tmpLineGraphVO.getPrevLinePX(), this.tmpLineGraphVO.getPrevLinePY(), this.linePX, this.linePY);
                    this.tmpLineGraphVO.setPrevLinePX(this.linePX);
                    this.tmpLineGraphVO.setPrevLinePY(this.linePY);
                    if (i == this.xLinkedList.size() - 1) {
                        if (this.tmpLineGraphVO.isViewLastValue()) {
                            g.drawString(Integer.toString(valueY), this.linePX + 2, this.linePY);
                        }
                        if (valueY > this.maxValueY) {
                            this.maxValueY = valueY;
                        }
                        limitOverItem = false;
                        if (this.tmpLineGraphVO.getLimitValueY() != 0) {
                            if (this.tmpLineGraphVO.getLimitValueY() > 0 && this.tmpLineGraphVO.getLimitValueY() <= valueY) {
                                limitOverItem = true;
                            } else if (this.tmpLineGraphVO.getLimitValueY() < 0 && this.tmpLineGraphVO.getLimitValueY() >= valueY) {
                                limitOverItem = true;
                            }
                        }
                        if (valueY == 0 && this.tmpLineGraphVO.getValueGetMethod().equals("getHeapUtilization")) {
                            limitOverItem = true;
                        }
                        if (limitOverItem) {
                            this.tmpLineGraphVO.setLimitOver(true);
                            ++limitOverItemCnt;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (limitOverItemCnt > 0) {
            this.drawOverBox(g, limitOverItemCnt);
        }
    }

    synchronized void drawOverBox(Graphics g, int cnt) {
        int px = 2;
        int py = 0;
        int width = 7;
        int height = (this.canvasY - 4) / cnt;
        int i = 0;
        while (i < this.graphItem.size()) {
            LineGraphVO tmpLineGraphVO = (LineGraphVO)this.graphItem.get(i);
            if (tmpLineGraphVO.isLimitOver()) {
                g.setColor(tmpLineGraphVO.getGraphColor());
                g.fillRect(px, py, width, height);
                py += height;
            }
            ++i;
        }
    }

    void setGraphItem() {
        int colorPos = 0;
        int limitValueY = 0;
        if (this.title.equals("JVM Utilization(%)")) {
            LineGraphVO xLineGraphVO = new LineGraphVO();
            xLineGraphVO.setId(HeapUtilizationId);
            xLineGraphVO.setTitle("HeapUtil");
            xLineGraphVO.setGraphColor(this.getColorTable(colorPos++));
            xLineGraphVO.setValueGetMethod("getHeapUtilization");
            limitValueY = Integer.parseInt(this.xWeblogicServerVO.getHeapUtilization());
            xLineGraphVO.setLimitValueY(limitValueY);
            this.graphItem.add(xLineGraphVO);
            xLineGraphVO = new LineGraphVO();
            xLineGraphVO.setId(ExecuteThreadUtilizationId);
            xLineGraphVO.setTitle("ExecuteThreadUtil");
            xLineGraphVO.setGraphColor(this.getColorTable(colorPos++));
            xLineGraphVO.setValueGetMethod("getExecuteThreadUtilization");
            limitValueY = Integer.parseInt(this.xWeblogicServerVO.getExecuteThreadUtilization());
            xLineGraphVO.setLimitValueY(limitValueY);
            this.graphItem.add(xLineGraphVO);
        } else if (this.title.equals("ExecuteThreads")) {
            LineGraphVO xLineGraphVO = new LineGraphVO();
            xLineGraphVO.setTitle("Total");
            xLineGraphVO.setId(ExecuteThreadTotalId);
            xLineGraphVO.setGraphColor(this.getColorTable(colorPos++));
            xLineGraphVO.setValueGetMethod("getExecuteThreadTotalCount");
            this.graphItem.add(xLineGraphVO);
            xLineGraphVO = new LineGraphVO();
            xLineGraphVO.setTitle("Active");
            xLineGraphVO.setId(ExecuteThreadActiveId);
            xLineGraphVO.setGraphColor(this.getColorTable(colorPos++));
            xLineGraphVO.setValueGetMethod("getExecuteThreadActivelCount");
            this.graphItem.add(xLineGraphVO);
            xLineGraphVO = new LineGraphVO();
            xLineGraphVO.setTitle("Pending");
            xLineGraphVO.setId(ExecuteThreadPendingId);
            xLineGraphVO.setGraphColor(this.getColorTable(colorPos++));
            xLineGraphVO.setValueGetMethod("getPendingRequestCurrentCount");
            limitValueY = Integer.parseInt(this.xWeblogicServerVO.getPendingRequests());
            xLineGraphVO.setLimitValueY(limitValueY);
            this.graphItem.add(xLineGraphVO);
        } else if (this.title.equals(OpenSocketsId)) {
            LineGraphVO xLineGraphVO = new LineGraphVO();
            xLineGraphVO.setGraphColor(this.getColorTable(colorPos++));
            xLineGraphVO.setId(OpenSocketsId);
            xLineGraphVO.setValueGetMethod("getOpenSocketsCurrentCount");
            xLineGraphVO.setTitle(OpenSocketsId);
            limitValueY = Integer.parseInt(this.xWeblogicServerVO.getOpenSocketsCurrentCount());
            xLineGraphVO.setLimitValueY(limitValueY);
            this.graphItem.add(xLineGraphVO);
        } else if (this.title.equals(OpenSessionsId)) {
            ServerMBeanDataVO tmpWeblogicMBeanDataVO;
            LinkedList tmpLinkedList = this.xServerMBeanDataListVO.getXLinkedList();
            if (tmpLinkedList.size() > 0 && (tmpWeblogicMBeanDataVO = (ServerMBeanDataVO)tmpLinkedList.getLast()).getWebAppCnt() > 0) {
                int i = 0;
                while (i < tmpWeblogicMBeanDataVO.getWebAppCnt()) {
                    LineGraphVO xLineGraphVO = new LineGraphVO();
                    xLineGraphVO.setGraphColor(this.getColorTable(i));
                    xLineGraphVO.setId(tmpWeblogicMBeanDataVO.getWebAppName(i));
                    xLineGraphVO.setTitle(tmpWeblogicMBeanDataVO.getWebAppName(i));
                    xLineGraphVO.setValueGetMethod("getOpenSessionsCurrentCounts");
                    xLineGraphVO.setLimitValueY(0);
                    xLineGraphVO.setViewLastValue(false);
                    this.graphItem.add(xLineGraphVO);
                    ++i;
                }
            }
        } else if (this.title.equals("JDBC Utilization(%)")) {
            ServerMBeanDataVO tmpWeblogicMBeanDataVO;
            LinkedList tmpLinkedList = this.xServerMBeanDataListVO.getXLinkedList();
            if (tmpLinkedList.size() > 0 && (tmpWeblogicMBeanDataVO = (ServerMBeanDataVO)tmpLinkedList.getLast()).getJdbcCnt() > 0) {
                int i = 0;
                while (i < tmpWeblogicMBeanDataVO.getJdbcCnt()) {
                    LineGraphVO xLineGraphVO = new LineGraphVO();
                    xLineGraphVO.setGraphColor(this.getColorTable(i));
                    xLineGraphVO.setId(tmpWeblogicMBeanDataVO.getJdbcName(i));
                    xLineGraphVO.setTitle(tmpWeblogicMBeanDataVO.getJdbcName(i));
                    xLineGraphVO.setValueGetMethod("getJdbcUtilization");
                    limitValueY = Integer.parseInt(this.xWeblogicServerVO.getJDBCConnectionUtilization());
                    xLineGraphVO.setLimitValueY(limitValueY);
                    this.graphItem.add(xLineGraphVO);
                    ++i;
                }
            }
        } else if (this.title.equals("Throughput")) {
            LineGraphVO xLineGraphVO = new LineGraphVO();
            xLineGraphVO.setTitle("Throughput");
            xLineGraphVO.setGraphColor(this.getColorTable(colorPos++));
            xLineGraphVO.setValueGetMethod("getThroughput");
            limitValueY = Integer.parseInt(this.xWeblogicServerVO.getThroughput());
            xLineGraphVO.setLimitValueY(limitValueY);
            this.graphItem.add(xLineGraphVO);
        } else if (this.title.equals("Heap Memory Utilization(%)") || this.title.equals("Execute Thread Utilization(%)") || this.title.equals("Pendig Requests") || this.title.equals("Throughputs") || this.title.equals("Open Sockets")) {
            this.xServerTabItemArray = this.xServerTabPanelThread.getXServerTabItemArray();
            if (this.xServerMBeanDataListVOArray[1] == null) {
                return;
            }
            LinkedList tmpLinkedList = this.xServerMBeanDataListVOArray[1].getXLinkedList();
            if (tmpLinkedList.size() > 0) {
                int i = 1;
                while (i < ServerTabPanelThread.getServerTabCnt()) {
                    LineGraphVO xLineGraphVO = new LineGraphVO();
                    xLineGraphVO.setGraphColor(this.getColorTable(i - 1));
                    xLineGraphVO.setId(this.xServerTabItemArray[i].getXWeblogicServerVO().getServerName());
                    xLineGraphVO.setTitle(xLineGraphVO.getId());
                    if (this.title.equals("Heap Memory Utilization(%)")) {
                        xLineGraphVO.setValueGetMethod("getHeapUtilization");
                        limitValueY = Integer.parseInt(this.xServerTabItemArray[i].getXWeblogicServerVO().getHeapUtilization());
                    } else if (this.title.equals("Execute Thread Utilization(%)")) {
                        xLineGraphVO.setValueGetMethod("getExecuteThreadUtilization");
                        limitValueY = Integer.parseInt(this.xServerTabItemArray[i].getXWeblogicServerVO().getExecuteThreadUtilization());
                    } else if (this.title.equals("Pendig Requests")) {
                        xLineGraphVO.setValueGetMethod("getPendingRequestCurrentCount");
                        limitValueY = Integer.parseInt(this.xServerTabItemArray[i].getXWeblogicServerVO().getPendingRequests());
                    } else if (this.title.equals("Throughputs")) {
                        xLineGraphVO.setValueGetMethod("getThroughput");
                        limitValueY = Integer.parseInt(this.xServerTabItemArray[i].getXWeblogicServerVO().getThroughput());
                    } else if (this.title.equals("Open Sockets")) {
                        xLineGraphVO.setValueGetMethod("getOpenSocketsCurrentCount");
                        limitValueY = Integer.parseInt(this.xServerTabItemArray[i].getXWeblogicServerVO().getOpenSocketsCurrentCount());
                    }
                    xLineGraphVO.setLimitValueY(limitValueY);
                    xLineGraphVO.setServerPos(i);
                    xLineGraphVO.setViewLastValue(false);
                    this.graphItem.add(xLineGraphVO);
                    ++i;
                }
            }
        }
        if (this.maxValueY < limitValueY) {
            this.maxValueY = limitValueY;
        }
    }

    Color getColorTable(int pos) {
        Color rColor;
        switch (pos) {
            case 0: {
                rColor = Color.BLUE.brighter();
                break;
            }
            case 1: {
                rColor = Color.red.brighter();
                break;
            }
            case 2: {
                rColor = Color.GREEN.brighter();
                break;
            }
            case 3: {
                rColor = Color.GRAY.brighter();
                break;
            }
            case 4: {
                rColor = Color.ORANGE.brighter();
                break;
            }
            case 5: {
                rColor = Color.CYAN.brighter();
                break;
            }
            case 6: {
                rColor = Color.PINK.brighter();
                break;
            }
            case 7: {
                rColor = Color.MAGENTA.brighter();
                break;
            }
            case 8: {
                rColor = Color.CYAN;
                break;
            }
            case 9: {
                rColor = Color.yellow.brighter();
                break;
            }
            default: {
                rColor = Color.BLACK;
            }
        }
        return rColor;
    }

    int convertTimeToXPixel(long time) {
        long timeWidth = this.maxValueX - this.minValueX;
        long timePos = time - this.minValueX;
        int result = (int)((float)timePos / (float)timeWidth * (float)this.graphWidth);
        return result + this.graphPX;
    }

    public String intToString(int value) {
        StringBuffer sb = new StringBuffer();
        String tmpStr = new String();
        int tmpValue = value < 0 ? -value : value;
        tmpStr = "";
        if (tmpValue >= 1024) {
            tmpStr = "K";
            tmpValue /= 1024;
        }
        if (tmpValue >= 1024) {
            tmpStr = "M";
            tmpValue /= 1024;
        }
        if (tmpValue >= 1024) {
            tmpStr = "G";
            tmpValue /= 1024;
        }
        sb.append(Integer.toString(tmpValue));
        sb.append(tmpStr);
        return sb.toString();
    }

    int convertTimeToYPixel(int value) {
        int result;
        if (value == 0) {
            result = this.graphPY + this.graphHeight;
        } else {
            result = this.graphHeight - this.yRem - (int)((float)value / (float)(this.maxValueY - this.minValueY) * (float)(this.graphHeight - this.yRem));
            result += this.graphPY + this.yRem;
        }
        return result;
    }

    void printXDotLine(Graphics g, int px, int py, int xLen, int spaceSize) {
        int i = px;
        while (i < px + xLen) {
            g.drawLine(i, py, i + spaceSize, py);
            i += spaceSize;
            i += spaceSize;
        }
    }

    void drawBoldLine(Graphics g, int x1, int y1, int x2, int y2, int width) {
        if (y1 == y2) {
            if (x1 == x2) {
                g.fillArc(x1 - width / 2, y1 - width / 2, width, width, 0, 360);
            } else {
                int[] xx = new int[]{x1, x2, x2, x1};
                int[] yy = new int[]{y1 - width / 2, y2 - width / 2, y2 + width / 2, y1 + width / 2};
                g.fillPolygon(xx, yy, 4);
                g.fillArc(x1 - width / 2, y1 - width / 2, width, width, 0, 360);
                g.fillArc(x2 - width / 2, y2 - width / 2, width, width, 0, 360);
            }
        } else if (x1 == x2) {
            int[] xx = new int[]{x1 + width / 2, x1 + width / 2, x1 - width / 2, x1 - width / 2};
            int[] yy = new int[]{y1, y2, y2, y1};
            g.fillPolygon(xx, yy, 4);
            g.fillArc(x1 - width / 2, y1 - width / 2, width, width, 0, 360);
            g.fillArc(x2 - width / 2, y2 - width / 2, width, width, 0, 360);
        } else {
            double r = Math.atan((double)(x1 - x2) / (double)(y2 - y1));
            int dx = (int)Math.round((double)width / 2.0 * Math.cos(r));
            int dy = (int)Math.round((double)width / 2.0 * Math.sin(r));
            int[] xx = new int[]{x1 + dx, x1 - dx, x2 - dx, x2 + dx};
            int[] yy = new int[]{y1 + dy, y1 - dy, y2 - dy, y2 + dy};
            g.fillPolygon(xx, yy, 4);
            g.fillArc(x1 - width / 2, y1 - width / 2, width, width, 0, 360);
            g.fillArc(x2 - width / 2, y2 - width / 2, width, width, 0, 360);
        }
    }

    public synchronized int getMaxValueY() {
        return this.maxValueY;
    }

    public synchronized void setMaxValueY(int maxValueY) {
        this.maxValueY = maxValueY;
    }

    public synchronized int getMinValueY() {
        return this.minValueY;
    }

    public synchronized void setMinValueY(int minValueY) {
        this.minValueY = minValueY;
    }

    public synchronized void setGraphValue(int min, int max) {
        this.minValueY = min;
        this.maxValueY = max;
    }

    public static synchronized boolean isDayMode() {
        return dayMode;
    }

    public static synchronized void setDayMode(boolean dayMode) {
        LineGraphJPanel.dayMode = dayMode;
    }

    public static String getExecuteThreadActiveId() {
        return ExecuteThreadActiveId;
    }

    public static String getExecuteThreadPendingId() {
        return ExecuteThreadPendingId;
    }

    public static String getExecuteThreadTotalId() {
        return ExecuteThreadTotalId;
    }

    public static String getExecuteThreadUtilizationId() {
        return ExecuteThreadUtilizationId;
    }

    public static String getHeapUtilizationId() {
        return HeapUtilizationId;
    }

    public static String getOpenSessionsId() {
        return OpenSessionsId;
    }

    public static String getOpenSocketsId() {
        return OpenSocketsId;
    }

    public int getCanvasX() {
        return this.canvasX;
    }

    public void setCanvasX(int canvasX) {
        this.canvasX = canvasX;
    }

    public int getCanvasY() {
        return this.canvasY;
    }

    public void setCanvasY(int canvasY) {
        this.canvasY = canvasY;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public int getCurrentHour() {
        return this.currentHour;
    }

    public void setCurrentHour(int currentHour) {
        this.currentHour = currentHour;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public long getDAY_LONG_VALUE() {
        return 43200000L;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public FontMetrics getDefaultFontMetrics() {
        return this.defaultFontMetrics;
    }

    public void setDefaultFontMetrics(FontMetrics defaultFontMetrics) {
        this.defaultFontMetrics = defaultFontMetrics;
    }

    public int getGRAPH_DIVIDE_DAY_CNT() {
        return 12;
    }

    public int getGRAPH_DIVIDE_HOUR_CNT() {
        return 6;
    }

    public int getGRAPH_EX_MARGIN() {
        return 30;
    }

    public int getGRAPH_EY_MARGIN() {
        return 50;
    }

    public int getGRAPH_SX_MARGIN() {
        return 40;
    }

    public int getGRAPH_SY_MARGIN() {
        return 0;
    }

    public int getGraphHeight() {
        return this.graphHeight;
    }

    public void setGraphHeight(int graphHeight) {
        this.graphHeight = graphHeight;
    }

    public LinkedList getGraphItem() {
        return this.graphItem;
    }

    public void setGraphItem(LinkedList graphItem) {
        this.graphItem = graphItem;
    }

    public int getGraphPX() {
        return this.graphPX;
    }

    public void setGraphPX(int graphPX) {
        this.graphPX = graphPX;
    }

    public int getGraphPY() {
        return this.graphPY;
    }

    public void setGraphPY(int graphPY) {
        this.graphPY = graphPY;
    }

    public int getGraphWidth() {
        return this.graphWidth;
    }

    public void setGraphWidth(int graphWidth) {
        this.graphWidth = graphWidth;
    }

    public int getGraphXDivideCnt() {
        return this.graphXDivideCnt;
    }

    public void setGraphXDivideCnt(int graphXDivideCnt) {
        this.graphXDivideCnt = graphXDivideCnt;
    }

    public long getGraphXLongDivideValue() {
        return this.graphXLongDivideValue;
    }

    public void setGraphXLongDivideValue(long graphXLongDivideValue) {
        this.graphXLongDivideValue = graphXLongDivideValue;
    }

    public long getGraphXLongTotalValue() {
        return this.graphXLongTotalValue;
    }

    public void setGraphXLongTotalValue(long graphXLongTotalValue) {
        this.graphXLongTotalValue = graphXLongTotalValue;
    }

    public int getGraphYDivideCnt() {
        return this.graphYDivideCnt;
    }

    public void setGraphYDivideCnt(int graphYDivideCnt) {
        this.graphYDivideCnt = graphYDivideCnt;
    }

    public long getHOUR_LONG_VALUE() {
        return 3600000L;
    }

    public int getLinePX() {
        return this.linePX;
    }

    public void setLinePX(int linePX) {
        this.linePX = linePX;
    }

    public int getLinePY() {
        return this.linePY;
    }

    public void setLinePY(int linePY) {
        this.linePY = linePY;
    }

    public long getMaxValueX() {
        return this.maxValueX;
    }

    public void setMaxValueX(long maxValueX) {
        this.maxValueX = maxValueX;
    }

    public long getMinValueX() {
        return this.minValueX;
    }

    public void setMinValueX(long minValueX) {
        this.minValueX = minValueX;
    }

    public int getPrevLinePX() {
        return this.prevLinePX;
    }

    public void setPrevLinePX(int prevLinePX) {
        this.prevLinePX = prevLinePX;
    }

    public int getPrevLinePY() {
        return this.prevLinePY;
    }

    public void setPrevLinePY(int prevLinePY) {
        this.prevLinePY = prevLinePY;
    }

    public long getStartValueX() {
        return this.startValueX;
    }

    public void setStartValueX(long startValueX) {
        this.startValueX = startValueX;
    }

    public Thread getT() {
        return this.t;
    }

    public void setT(Thread t) {
        this.t = t;
    }

    public long getTEN_MINUTE_LONG_VALUE() {
        return 600000L;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public LineGraphVO getTmpLineGraphVO() {
        return this.tmpLineGraphVO;
    }

    public void setTmpLineGraphVO(LineGraphVO tmpLineGraphVO) {
        this.tmpLineGraphVO = tmpLineGraphVO;
    }

    public LinkedList getXLinkedList() {
        return this.xLinkedList;
    }

    public void setXLinkedList(LinkedList linkedList) {
        this.xLinkedList = linkedList;
    }

    public ServerMBeanDataListVO getXServerMBeanDataListVO() {
        return this.xServerMBeanDataListVO;
    }

    public void setXServerMBeanDataListVO(ServerMBeanDataListVO serverMBeanDataListVO) {
        this.xServerMBeanDataListVO = serverMBeanDataListVO;
    }

    public WeblogicServerVO getXWeblogicServerVO() {
        return this.xWeblogicServerVO;
    }

    public void setXWeblogicServerVO(WeblogicServerVO weblogicServerVO) {
        this.xWeblogicServerVO = weblogicServerVO;
    }

    public int getYRem() {
        return this.yRem;
    }

    public void setYRem(int rem) {
        this.yRem = rem;
    }

    public int getTabType() {
        return this.tabType;
    }

    public void setTabType(int tabType) {
        this.tabType = tabType;
    }
}

