/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.UI;

import com.sysmon.WLMonitor.UI.graph.LineGraphJPanel;
import com.sysmon.WLMonitor.log.Logger;
import com.sysmon.WLMonitor.vo.ServerMBeanDataListVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class TabSummary {
    JPanel xSummaryPanel;
    LineGraphJPanel xGraphCanvasHeapUtilization;
    LineGraphJPanel xGraphCanvasExecuteThreadUtilization;
    LineGraphJPanel xGraphCanvasExecuteThreadPendingRequest;
    LineGraphJPanel xGraphCanvasThroughput;
    LineGraphJPanel xGraphCanvasOpenSockets;
    Logger logger = Logger.getInstance();
    WeblogicServerVO xWeblogicServerVO = null;
    ServerMBeanDataListVO xServerMBeanDataListVO = null;

    public TabSummary(WeblogicServerVO xWeblogicServerVO, ServerMBeanDataListVO xServerMBeanDataListVO) {
        this.xWeblogicServerVO = xWeblogicServerVO;
        this.xServerMBeanDataListVO = xServerMBeanDataListVO;
        this.xSummaryPanel = new JPanel();
        this.xSummaryPanel.setLayout(new GridLayout(3, 2, 2, 2));
        this.xGraphCanvasHeapUtilization = new LineGraphJPanel("Heap Memory Utilization(%)", xWeblogicServerVO, xServerMBeanDataListVO, 1);
        this.xGraphCanvasHeapUtilization.setGraphValue(0, 100);
        this.xGraphCanvasExecuteThreadUtilization = new LineGraphJPanel("Execute Thread Utilization(%)", xWeblogicServerVO, xServerMBeanDataListVO, 1);
        this.xGraphCanvasExecuteThreadUtilization.setGraphValue(0, 100);
        this.xGraphCanvasExecuteThreadPendingRequest = new LineGraphJPanel("Pendig Requests", xWeblogicServerVO, xServerMBeanDataListVO, 1);
        this.xGraphCanvasExecuteThreadPendingRequest.setGraphValue(0, 20);
        this.xGraphCanvasThroughput = new LineGraphJPanel("Throughputs", xWeblogicServerVO, xServerMBeanDataListVO, 1);
        this.xGraphCanvasThroughput.setGraphValue(0, 100);
        this.xGraphCanvasOpenSockets = new LineGraphJPanel("Open Sockets", xWeblogicServerVO, xServerMBeanDataListVO, 1);
        this.xGraphCanvasOpenSockets.setGraphValue(0, 100);
        this.xSummaryPanel.add(this.xGraphCanvasHeapUtilization);
        this.xSummaryPanel.add(this.xGraphCanvasExecuteThreadUtilization);
        this.xSummaryPanel.add(this.xGraphCanvasExecuteThreadPendingRequest);
        this.xSummaryPanel.add(this.xGraphCanvasThroughput);
        this.xSummaryPanel.add(this.xGraphCanvasOpenSockets);
    }

    public Object getSummaryTabItem() {
        return this.xSummaryPanel;
    }

    public void repaint() {
        this.xGraphCanvasHeapUtilization.calcData();
        this.xGraphCanvasExecuteThreadUtilization.calcData();
        this.xGraphCanvasExecuteThreadPendingRequest.calcData();
        this.xGraphCanvasThroughput.calcData();
        this.xGraphCanvasOpenSockets.calcData();
        this.xGraphCanvasHeapUtilization.repaint();
        this.xGraphCanvasExecuteThreadUtilization.repaint();
        this.xGraphCanvasExecuteThreadPendingRequest.repaint();
        this.xGraphCanvasThroughput.repaint();
        this.xGraphCanvasOpenSockets.repaint();
    }
}

