/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.UI;

import com.sysmon.WLMonitor.UI.graph.LineGraphJPanel;
import com.sysmon.WLMonitor.log.Logger;
import com.sysmon.WLMonitor.vo.ServerMBeanDataListVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class TabItemSummary {
    JPanel xSummaryPanel;
    LineGraphJPanel xGraphCanvasHeapUsed;
    LineGraphJPanel xGraphCanvasExecuteThreads;
    LineGraphJPanel xGraphOpenSockets;
    LineGraphJPanel xGraphOpenSessions;
    LineGraphJPanel xGraphCanvasJDBC;
    LineGraphJPanel xGraphCanvasThroughput;
    Logger logger = Logger.getInstance();
    WeblogicServerVO xWeblogicServerVO = null;
    ServerMBeanDataListVO xServerMBeanDataListVO = null;

    public TabItemSummary(WeblogicServerVO xWeblogicServerVO, ServerMBeanDataListVO xServerMBeanDataListVO) {
        this.xWeblogicServerVO = xWeblogicServerVO;
        this.xServerMBeanDataListVO = xServerMBeanDataListVO;
        this.xSummaryPanel = new JPanel();
        this.xSummaryPanel.setLayout(new GridLayout(3, 2, 2, 2));
        this.xGraphCanvasHeapUsed = new LineGraphJPanel("JVM Utilization(%)", xWeblogicServerVO, xServerMBeanDataListVO);
        this.xGraphCanvasHeapUsed.setGraphValue(0, 100);
        this.xGraphCanvasExecuteThreads = new LineGraphJPanel("ExecuteThreads", xWeblogicServerVO, xServerMBeanDataListVO);
        this.xGraphCanvasExecuteThreads.setGraphValue(0, 20);
        this.xGraphOpenSockets = new LineGraphJPanel("OpenSockets", xWeblogicServerVO, xServerMBeanDataListVO);
        this.xGraphOpenSessions = new LineGraphJPanel("OpenSessions", xWeblogicServerVO, xServerMBeanDataListVO);
        this.xGraphOpenSessions.setGraphValue(0, 2000);
        this.xGraphCanvasThroughput = new LineGraphJPanel("Throughput", xWeblogicServerVO, xServerMBeanDataListVO);
        this.xGraphCanvasThroughput.setGraphValue(0, 100);
        this.xGraphCanvasJDBC = new LineGraphJPanel("JDBC Utilization(%)", xWeblogicServerVO, xServerMBeanDataListVO);
        this.xGraphCanvasJDBC.setGraphValue(0, 100);
        this.xSummaryPanel.add(this.xGraphCanvasHeapUsed);
        this.xSummaryPanel.add(this.xGraphCanvasExecuteThreads);
        this.xSummaryPanel.add(this.xGraphCanvasJDBC);
        this.xSummaryPanel.add(this.xGraphCanvasThroughput);
        this.xSummaryPanel.add(this.xGraphOpenSockets);
        this.xSummaryPanel.add(this.xGraphOpenSessions);
    }

    public Object getSummaryTabItem() {
        return this.xSummaryPanel;
    }

    public void repaint() {
        this.xGraphCanvasHeapUsed.calcData();
        this.xGraphCanvasExecuteThreads.calcData();
        this.xGraphCanvasJDBC.calcData();
        this.xGraphCanvasThroughput.calcData();
        this.xGraphOpenSockets.calcData();
        this.xGraphOpenSessions.calcData();
        this.xGraphCanvasHeapUsed.repaint();
        this.xGraphCanvasExecuteThreads.repaint();
        this.xGraphCanvasJDBC.repaint();
        this.xGraphCanvasThroughput.repaint();
        this.xGraphOpenSockets.repaint();
        this.xGraphOpenSessions.repaint();
    }
}

