/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.UI;

import com.sysmon.WLMonitor.log.Logger;
import com.sysmon.WLMonitor.vo.MainVO;
import com.sysmon.WLMonitor.vo.ServerMBeanDataListVO;
import com.sysmon.WLMonitor.vo.ServerMBeanDataVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TabItemExecuteThreads {
    JPanel xExecuteThreadPanel;
    ServerMBeanDataVO xServerMBeanDataVO;
    JScrollPane sPane;
    JTable xJTable;
    TableColumnModel xTableColumnModel;
    AlignmentTableModel atm;
    int rowCnt = 10;
    int colCnt = 4;
    boolean[] threadError;
    Logger logger = Logger.getInstance();
    WeblogicServerVO xWeblogicServerVO = null;
    ServerMBeanDataListVO xServerMBeanDataListVO = null;

    public TabItemExecuteThreads(WeblogicServerVO xWeblogicServerVO, ServerMBeanDataListVO xServerMBeanDataListVO) {
        this.xWeblogicServerVO = xWeblogicServerVO;
        this.xServerMBeanDataListVO = xServerMBeanDataListVO;
        this.xExecuteThreadPanel = new JPanel();
        this.xExecuteThreadPanel.setLayout(new BorderLayout());
        this.xJTable = new JTable();
        this.sPane = new JScrollPane(this.xJTable);
        this.xExecuteThreadPanel.add(this.sPane);
    }

    void setTable() {
        this.atm = new AlignmentTableModel();
        this.xJTable.setAutoCreateColumnsFromModel(false);
        this.xJTable.setModel(this.atm);
        this.threadError = new boolean[this.rowCnt];
        int i = 0;
        while (i < this.atm.headers.length) {
            RowCellRender rend = new RowCellRender();
            rend.setHorizontalAlignment(this.atm.alignment[i]);
            TableColumn column = new TableColumn(i, this.atm.columnWidth[i], rend, null);
            this.xJTable.addColumn(column);
            ++i;
        }
    }

    public Object getExecuteThreads() {
        return this.xExecuteThreadPanel;
    }

    public void repaint() {
        Date date = new Date();
        if (this.xServerMBeanDataListVO.getXLinkedList().size() > 0) {
            this.xServerMBeanDataVO = (ServerMBeanDataVO)this.xServerMBeanDataListVO.getXLinkedList().getLast();
            int threadCnt = this.xServerMBeanDataVO.getThreadCnt();
            if (threadCnt == 0) {
                this.clearJTable();
            } else {
                if (threadCnt != this.rowCnt) {
                    this.rowCnt = threadCnt;
                    this.setTable();
                }
                int i = 0;
                while (i < this.rowCnt) {
                    this.threadError[i] = false;
                    this.atm.setValueAt(this.xServerMBeanDataVO.getThreadNo(i), this.rowCnt - 1 - i, 0);
                    this.atm.setValueAt(Integer.toString(this.xServerMBeanDataVO.getThreadServicedRequestTotalCount(i)), this.rowCnt - 1 - i, 1);
                    int limitValue = (int)(date.getTime() - this.xServerMBeanDataVO.getThreadCurrentRequestStartTime(i));
                    if (this.xServerMBeanDataVO.getThreadCurrentRequestStartTime(i) == 0L || this.xServerMBeanDataVO.getThreadCurrentRequest(i).equals("Idle")) {
                        limitValue = 0;
                    }
                    this.atm.setValueAt(String.valueOf(Integer.toString(limitValue)) + " ", this.rowCnt - 1 - i, 2);
                    this.atm.setValueAt("  " + this.xServerMBeanDataVO.getThreadCurrentRequest(i), this.rowCnt - 1 - i, 3);
                    if (Integer.parseInt(this.xWeblogicServerVO.getExecuteThreadElapsedLimitSecond()) <= limitValue / 1000) {
                        this.threadError[i] = true;
                        MainVO.setError(this.xWeblogicServerVO.getServerName(), 1, true);
                        this.logger.printErr(this.xWeblogicServerVO.getServerName(), "ExecuteThreadRunTimeOver [" + limitValue / 1000 + "<" + this.xWeblogicServerVO.getExecuteThreadElapsedLimitSecond() + "] " + this.xServerMBeanDataVO.getThreadCurrentRequest(i));
                    } else {
                        this.threadError[i] = false;
                    }
                    ++i;
                }
            }
        }
        if (this.atm != null) {
            this.atm.fireTableDataChanged();
        }
    }

    void clearJTable() {
        if (this.atm == null) {
            return;
        }
        int i = 0;
        while (i < this.rowCnt) {
            int j = 0;
            while (j < this.colCnt) {
                this.atm.setValueAt("", i, j);
                ++j;
            }
            ++i;
        }
    }

    public int getRowCnt() {
        return this.rowCnt;
    }

    public void setRowCnt(int rowCnt) {
        this.rowCnt = rowCnt;
    }

    public JScrollPane getSPane() {
        return this.sPane;
    }

    public void setSPane(JScrollPane pane) {
        this.sPane = pane;
    }

    public JPanel getXExecuteThreadPanel() {
        return this.xExecuteThreadPanel;
    }

    public void setXExecuteThreadPanel(JPanel executeThreadPanel) {
        this.xExecuteThreadPanel = executeThreadPanel;
    }

    public JTable getXJTable() {
        return this.xJTable;
    }

    public void setXJTable(JTable table) {
        this.xJTable = table;
    }

    public ServerMBeanDataListVO getXServerMBeanDataListVO() {
        return this.xServerMBeanDataListVO;
    }

    public void setXServerMBeanDataListVO(ServerMBeanDataListVO serverMBeanDataListVO) {
        this.xServerMBeanDataListVO = serverMBeanDataListVO;
    }

    public TableColumnModel getXTableColumnModel() {
        return this.xTableColumnModel;
    }

    public void setXTableColumnModel(TableColumnModel tableColumnModel) {
        this.xTableColumnModel = tableColumnModel;
    }

    public WeblogicServerVO getXWeblogicServerVO() {
        return this.xWeblogicServerVO;
    }

    public void setXWeblogicServerVO(WeblogicServerVO weblogicServerVO) {
        this.xWeblogicServerVO = weblogicServerVO;
    }

    class AlignmentTableModel
    extends AbstractTableModel {
        String[] headers = new String[]{"\uc2a4\ub808\ub4dc\ubc88\ud638", "\uc694\uccad\ucd1d\uac74\uc218", "\uacbd\uacfc\uc2dc\uac04(ms)", "\ud604\uc7ac\uc694\uccad\ucc98\ub9ac\ub0b4\uc6a9"};
        int[] columnWidth = new int[]{50, 50, 50, 500};
        int[] alignment;
        String[][] data;

        AlignmentTableModel() {
            int[] nArray = new int[4];
            nArray[2] = 4;
            nArray[3] = 2;
            this.alignment = nArray;
            this.data = new String[TabItemExecuteThreads.this.rowCnt][4];
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return this.headers.length;
        }

        public String getColumnName(int col) {
            return this.headers[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public void setValueAt(String str, int row, int col) {
            this.data[row][col] = str;
        }
    }

    class RowCellRender
    extends DefaultTableCellRenderer {
        Color[] bg_colorway = new Color[]{Color.red, Color.cyan.darker(), Color.darkGray, Color.green, Color.gray, Color.magenta, Color.blue, Color.pink, Color.white, Color.yellow, Color.orange.darker(), Color.darkGray.brighter(), Color.cyan, Color.orange, Color.green.darker(), Color.gray.darker(), Color.magenta.darker(), Color.blue.brighter(), Color.pink.darker(), Color.white.darker(), Color.red.brighter(), Color.yellow.darker()};
        Color[] fg_colorway = new Color[]{Color.black, Color.black, Color.white, Color.black, Color.white, Color.black, Color.blue, Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.black, Color.black};
        int rowcount;

        int getRow() {
            return this.rowcount;
        }

        void setRow(int count) {
            this.rowcount = count;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (TabItemExecuteThreads.this.xServerMBeanDataVO != null) {
                if (TabItemExecuteThreads.this.threadError[TabItemExecuteThreads.this.rowCnt - 1 - row]) {
                    this.setForeground(Color.black);
                    this.setBackground(Color.orange);
                } else if (TabItemExecuteThreads.this.xServerMBeanDataVO.getThreadServicedRequestTotalCount(TabItemExecuteThreads.this.rowCnt - 1 - row) == 0) {
                    this.setForeground(Color.black);
                    this.setBackground(Color.white);
                } else {
                    this.setForeground(Color.black);
                    this.setBackground(Color.GREEN.brighter());
                }
            } else {
                this.setForeground(Color.black);
                this.setBackground(Color.white);
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }
}

