/*
 * Decompiled with CFR 0.152.
 */
package com.sysmon.WLMonitor.UI;

import com.sysmon.WLMonitor.UI.ServerTabItem;
import com.sysmon.WLMonitor.config.Config;
import com.sysmon.WLMonitor.log.Logger;
import com.sysmon.WLMonitor.main.MainFrame;
import com.sysmon.WLMonitor.main.ToolBar;
import com.sysmon.WLMonitor.vo.DefineCommonVO;
import com.sysmon.WLMonitor.vo.MainVO;
import com.sysmon.WLMonitor.vo.ServerMBeanDataListVO;
import com.sysmon.WLMonitor.vo.WeblogicDomainListVO;
import com.sysmon.WLMonitor.vo.WeblogicDomainVO;
import com.sysmon.WLMonitor.vo.WeblogicServerVO;
import java.awt.BorderLayout;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ServerTabPanelThread
implements Runnable {
    static ServerTabPanelThread ServerTabPanel;
    JPanel xServerTabPanel = new JPanel();
    JTabbedPane xJTabbedPaneServerTab = new JTabbedPane(2);
    ServerTabItem[] xServerTabItemArray = new ServerTabItem[DefineCommonVO.getMAX_SERVER_TAB()];
    ServerMBeanDataListVO[] xServerMBeanDataListVO = new ServerMBeanDataListVO[DefineCommonVO.getMAX_SERVER_TAB()];
    JScrollPane xJScrollPane;
    static int serverTabCnt;
    WeblogicDomainVO xWeblogicDomainVO = null;
    Logger logger = Logger.getInstance();
    ImageIcon errorImageIcon = new ImageIcon("icons/errorTabItemIcon.gif");
    ImageIcon normalImageIcon = new ImageIcon("icons/normalTabItemIcon.gif");
    boolean bRunnable = false;
    Thread t;

    static {
        serverTabCnt = 0;
    }

    public void repaintSelectedServerTabPanel() {
        if (this.xJTabbedPaneServerTab.getTabCount() > 0) {
            int serverTabPos = this.xJTabbedPaneServerTab.getSelectedIndex();
            ServerTabItem selectedServerTabItem = this.xServerTabItemArray[serverTabPos];
            selectedServerTabItem.repaint();
        }
    }

    public ServerTabPanelThread() {
        this.xServerTabPanel.setLayout(new BorderLayout());
        this.xServerTabPanel.add(this.xJTabbedPaneServerTab);
        this.xJTabbedPaneServerTab.addChangeListener(new ServerTabChangedListener());
    }

    public static ServerTabPanelThread getInstance() {
        if (ServerTabPanel == null) {
            ServerTabPanel = new ServerTabPanelThread();
        }
        return ServerTabPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread() {
        ServerTabPanelThread serverTabPanelThread = this;
        synchronized (serverTabPanelThread) {
            if (!this.bRunnable) {
                this.t = new Thread(this);
                this.t.start();
                this.bRunnable = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        ServerTabPanelThread serverTabPanelThread = this;
        synchronized (serverTabPanelThread) {
            if (this.bRunnable) {
                this.t.stop();
                this.bRunnable = false;
            }
        }
    }

    public void run() {
        int sleepMSec = Integer.parseInt(this.xWeblogicDomainVO.getIntervalSec()) * 1000;
        while (true) {
            try {
                int i = 1;
                while (i < this.xJTabbedPaneServerTab.getTabCount()) {
                    this.xServerTabItemArray[i].getData();
                    ++i;
                }
                this.xServerTabItemArray[0].getData();
                this.setErrorMarking();
                Thread.sleep(sleepMSec);
                MainVO.clearError();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void setErrorMarking() {
        JTabbedPane xJTabbedPaneServerItemTab;
        MainVO.errorCompute();
        int i = 0;
        while (i < this.xJTabbedPaneServerTab.getTabCount()) {
            xJTabbedPaneServerItemTab = this.xServerTabItemArray[i].getXJTabbedPaneServerTabItem();
            if (MainVO.getServerError(i)) {
                this.xJTabbedPaneServerTab.setIconAt(i, this.errorImageIcon);
            } else {
                this.xJTabbedPaneServerTab.setIconAt(i, this.normalImageIcon);
            }
            int j = 0;
            while (j < xJTabbedPaneServerItemTab.getTabCount()) {
                if (MainVO.getServerItemError(i, j)) {
                    xJTabbedPaneServerItemTab.setIconAt(j, this.errorImageIcon);
                } else {
                    xJTabbedPaneServerItemTab.setIconAt(j, this.normalImageIcon);
                }
                ++j;
            }
            ++i;
        }
        if (!MainVO.isScreenfix() && MainVO.getError() && !MainVO.getServerError(this.xJTabbedPaneServerTab.getSelectedIndex()) && MainVO.getFirstServerErrorPos() > -1) {
            this.xJTabbedPaneServerTab.setSelectedIndex(MainVO.getFirstServerErrorPos());
        }
        if (!MainVO.isScreenfix() && MainVO.getServerError(this.xJTabbedPaneServerTab.getSelectedIndex())) {
            xJTabbedPaneServerItemTab = this.xServerTabItemArray[this.xJTabbedPaneServerTab.getSelectedIndex()].getXJTabbedPaneServerTabItem();
            if (!MainVO.getServerItemError(this.xJTabbedPaneServerTab.getSelectedIndex(), xJTabbedPaneServerItemTab.getSelectedIndex()) && MainVO.getFirstServerItemErrorPos(xJTabbedPaneServerItemTab.getSelectedIndex()) > -1) {
                xJTabbedPaneServerItemTab.setSelectedIndex(MainVO.getFirstServerItemErrorPos(xJTabbedPaneServerItemTab.getSelectedIndex()));
            }
        }
        MainVO.playAlarmSound();
    }

    public synchronized void addServerTabPanel(WeblogicServerVO xWeblogicServerVO) {
        this.logger.setLogger(this.xWeblogicDomainVO.getDomainName());
        if (DefineCommonVO.getMAX_SERVER_TAB() > serverTabCnt) {
            ServerTabItem xServerTabItem;
            if (serverTabCnt == 0) {
                WeblogicServerVO summaryWeblogicServerVO = new WeblogicServerVO();
                summaryWeblogicServerVO.setServerName("Summary");
                xServerTabItem = new ServerTabItem(1, summaryWeblogicServerVO);
                JTabbedPane tabItem = xServerTabItem.getServerTabItem();
                this.xJTabbedPaneServerTab.addTab(summaryWeblogicServerVO.getServerName(), this.normalImageIcon, tabItem);
                this.xServerTabItemArray[ServerTabPanelThread.serverTabCnt] = xServerTabItem;
                ++serverTabCnt;
            }
            xServerTabItem = new ServerTabItem(2, xWeblogicServerVO);
            JTabbedPane tabItem = xServerTabItem.getServerTabItem();
            this.xJTabbedPaneServerTab.addTab(xWeblogicServerVO.getServerName(), this.normalImageIcon, tabItem);
            this.xServerTabItemArray[ServerTabPanelThread.serverTabCnt] = xServerTabItem;
            this.xServerMBeanDataListVO[ServerTabPanelThread.serverTabCnt] = xServerTabItem.getXServerMBeanDataListVO();
            this.logger.printInfo(this.xWeblogicDomainVO.getDomainName(), "Starting WLMonitor 2.5b2...");
            ++serverTabCnt;
        }
    }

    public synchronized void removeServerTabAllPanel() {
        this.stopThread();
        this.xJTabbedPaneServerTab.removeAll();
        int i = 0;
        while (i < this.xJTabbedPaneServerTab.getTabCount()) {
            this.xServerTabItemArray[i] = null;
            this.xServerMBeanDataListVO[i] = null;
            ++i;
        }
        this.xWeblogicDomainVO = null;
        serverTabCnt = 0;
        MainFrame.getInstance().setMainTitle(MainVO.getConfigFileName());
        ToolBar.getInstance().getbtnExecuteMonitoring().setEnabled(true);
    }

    public void executeServerMonitoring() {
        if (this.xWeblogicDomainVO != null) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "\ubaa8\ub2c8\ud130\ub9c1 \uc911\uc785\ub2c8\ub2e4.");
            return;
        }
        WeblogicDomainListVO tmpWeblogicDomainListVO = Config.getInstance().readConfig();
        this.xWeblogicDomainVO = tmpWeblogicDomainListVO.getSelectedWeblogicDomainVO();
        if (this.xWeblogicDomainVO == null) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "\ubaa8\ub2c8\ud130\ub9c1 \ub300\uc0c1\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \ud658\uacbd\uc124\uc815\uc744 \ud1b5\ud558\uc5ec \ubaa8\ub2c8\ud130\ub9c1 \ub300\uc0c1\uc744 \ucd94\uac00\ud558\uc138\uc694.");
            return;
        }
        ArrayList tmpWeblogicServers = this.xWeblogicDomainVO.getWeblogicServers();
        int cnt = 0;
        int i = 0;
        while (i < tmpWeblogicServers.size()) {
            WeblogicServerVO tmpWeblogicServerVO = (WeblogicServerVO)tmpWeblogicServers.get(i);
            if (tmpWeblogicServerVO.isSelectedMonitoring()) {
                this.addServerTabPanel(tmpWeblogicServerVO);
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "\ubaa8\ub2c8\ud130\ub9c1 \ub300\uc0c1\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \ud658\uacbd\uc124\uc815\uc744 \ud1b5\ud558\uc5ec \ubaa8\ub2c8\ud130\ub9c1 \ub300\uc0c1\uc744 \ucd94\uac00\ud558\uc138\uc694.");
        } else {
            ToolBar.getInstance().getbtnExecuteMonitoring().setEnabled(false);
            this.startThread();
        }
    }

    public synchronized ServerTabPanelThread getServerTabPanel() {
        return ServerTabPanel;
    }

    public synchronized void setServerTabPanel(ServerTabPanelThread serverTabPanel) {
        ServerTabPanel = serverTabPanel;
    }

    public synchronized JTabbedPane getXJTabbedPane() {
        return this.xJTabbedPaneServerTab;
    }

    public synchronized void setXJTabbedPane(JTabbedPane tabbedPane) {
        this.xJTabbedPaneServerTab = tabbedPane;
    }

    public synchronized JPanel getXServerTabPanel() {
        return this.xServerTabPanel;
    }

    public synchronized void setXServerTabPanel(JPanel serverTabPanel) {
        this.xServerTabPanel = serverTabPanel;
    }

    public synchronized JScrollPane getXJScrollPane() {
        return this.xJScrollPane;
    }

    public synchronized void setXJScrollPane(JScrollPane scrollPane) {
        this.xJScrollPane = scrollPane;
    }

    public WeblogicDomainVO getXWeblogicDomainVO() {
        return this.xWeblogicDomainVO;
    }

    public void setXWeblogicDomainVO(WeblogicDomainVO weblogicDomainVO) {
        this.xWeblogicDomainVO = weblogicDomainVO;
    }

    public ServerMBeanDataListVO[] getXServerMBeanDataListVO() {
        return this.xServerMBeanDataListVO;
    }

    public void setXServerMBeanDataListVO(ServerMBeanDataListVO[] serverMBeanDataListVO) {
        this.xServerMBeanDataListVO = serverMBeanDataListVO;
    }

    public ServerTabItem[] getXServerTabItemArray() {
        return this.xServerTabItemArray;
    }

    public void setXServerTabItemArray(ServerTabItem[] serverTabItemArray) {
        this.xServerTabItemArray = serverTabItemArray;
    }

    public static int getServerTabCnt() {
        return serverTabCnt;
    }

    public static void setServerTabCnt(int serverTabCnt) {
        ServerTabPanelThread.serverTabCnt = serverTabCnt;
    }

    class ServerTabChangedListener
    implements ChangeListener {
        ServerTabChangedListener() {
        }

        public void stateChanged(ChangeEvent ev) {
            int idx = ServerTabPanelThread.this.xJTabbedPaneServerTab.getSelectedIndex();
            String serverDesc = "";
            if (idx > -1) {
                if (MainVO.getMute(idx)) {
                    ToolBar.getInstance().getBtnMute().setSelected(true);
                } else {
                    ToolBar.getInstance().getBtnMute().setSelected(false);
                }
                if (ServerTabPanelThread.this.xServerTabItemArray[idx] != null) {
                    serverDesc = ServerTabPanelThread.this.xServerTabItemArray[idx].getXWeblogicServerVO().getServerDescription();
                }
                if (idx == 0) {
                    MainFrame.getInstance().setMainTitle("[" + ServerTabPanelThread.this.xWeblogicDomainVO.getDomainName() + "] ");
                } else {
                    MainFrame.getInstance().setMainTitle("[" + ServerTabPanelThread.this.xWeblogicDomainVO.getDomainName() + " - " + ServerTabPanelThread.this.xJTabbedPaneServerTab.getTitleAt(idx) + "] " + serverDesc);
                }
            }
        }
    }
}

