 /*******************************************************************
 * CodeRedScanner Version 2 08/07/2001                              *
 * Kirby Kuehl (kkuehl@cisco.com)                                   *
 * Tested on FreeBSD, Linux, and Solaris                            *
 ********************************************************************
 * @(#)coderedscanner.c v2.4 08/11/2001 Kirby Kuehl and Rob Thomas
 * @(#)kkuehl@cisco.com robt@cymru.com
 *
 * 08 AUG 2001 v2.3 Enhancements robt@cymru.com
 * - Added POSIX threads
 *
 * 11 AUG 2001 v2.4 Enhancements kkuehl@cisco.com and robt@cymru.com
 * - Compensated for a threads issue in some Solaris 8 implementations.
 * - Added additional check for IIS 4 servers.
 * - Improved signal handling for the threads.  This included the
 *   addition of pthread_detach() to avoid the lengthy TCP
 *   connection attempt timeout.
 * - Added -c <timeout in seconds> option so that a scan timeout
 *   value could be easily set.  The default timeout is 15 seconds.
 * - Added code to handle 404 error message from GET x.ida.
 * - Testing, testing, testing.  :)
 *
 ********************************************************************/

#define _REENTRANT

#include "coderedscan.h"

typedef struct {
	char ipaddress[1024];
	FILE *output;
	unsigned int id;
} threadWorkOrder_t;

threadWorkOrder_t *workOrder;
int id = 0;
pthread_t peerVersionQuery[255];

void timedout(int signo);
void usage();
int versionquery(threadWorkOrder_t *);

int main(int argc, char *argv[])
{
   extern int optopt;
   extern char *optarg;
   int c = 0;
   int range = 0;
   int list = 0;
   int singlehost =0;
   int max_thread = 1;
   int timeout = 15;
   int high = 0;
   int low = 0;
   int loop = 0;
   struct sockaddr_in sin; 
   unsigned long start;
   unsigned long end;
   unsigned long counter;
   char outputfile[1024];
   char ipaddress[1024];
   char startip[1024];
   char endip[1024]; 
   struct hostent *host;
   struct in_addr inaddr;
   FILE *input, *output;

   if((argc < 3) || (argc > 9))
      usage();
   while((c = getopt(argc,argv,"h:s:e:l:t:c:")) != -1)
   {
      switch(c)
      {
         case 'h' :  /* Single host scan  */
         {
            if(inet_pton(AF_INET,optarg, &inaddr))
               host = gethostbyaddr((char *) &inaddr, sizeof(inaddr),AF_INET);
            else
               host = gethostbyname(optarg);
            sprintf(outputfile,"%s.txt",optarg);
            sprintf(ipaddress,"%s",optarg);
            singlehost = 1;
            break;
         } 
         case 's' :  /* Starting ip address */
         {
            if((start = inet_addr(optarg))==INADDR_NONE)
            {
               fprintf(stderr,"%s is an invalid IP Address.\n",optarg);
               exit(-1);
            }
            sprintf(startip,"%s",optarg);
            break;
         }
         case 'e' : /* Ending ip address */
         {
            if((end = inet_addr(optarg))==INADDR_NONE)
            {
               fprintf(stderr,"%s is an invalid IP Address.\n",optarg);
               exit(-1);
            }
            sprintf(endip,"%s",optarg);
            sprintf(outputfile,"%s-%s.txt",startip,endip);
            range = 1;
            break;
         }
         case 'l' :
         {
            if((input = fopen(optarg, "r")) == NULL)
            {
                printf("Unable to open %s\n",optarg);
                exit(-1);
            }
            sprintf(outputfile,"results-%s",optarg); 
            list = 1;
            break;
         }
		 case 't' : /* Maximum number of concurrent threads */
		 {
			if(atoi(optarg) > 255) {
	 	 	 	fprintf(stderr, "Maximum threads = 255, setting to 255.\n");
				max_thread = 255;
			} else if(atoi(optarg) < 1) {
				max_thread = 1;
	 	 	} else {
				max_thread = atoi(optarg);
			}
	 	 	break;
		 }
		 case 'c' : /* Scan timeout */
		 {
			if(atoi(optarg) < 5) {
			   fprintf(stderr, "Minimum timeout is 5 seconds, setting to 5.\n");
			   timeout = 5;
			} else {
				timeout = atoi(optarg);
			}
			break;
		 }
         default:
         {
            usage(); 
            break;
         }
        
      }
   }

  if((output=fopen(outputfile,"a")) == NULL)
  {
     printf("Unable to open %s for writing.\n",outputfile);
     exit(-1);
  } 

  /* Not threaded due to a possible issue in Solaris 8. */
  if(singlehost)
  {
	 workOrder = (threadWorkOrder_t *)malloc(sizeof(threadWorkOrder_t));
	 workOrder->output = output;
	 sprintf(workOrder->ipaddress, "%s", ipaddress);
	 versionquery(workOrder);
  }
 
  if(range)
  {
		 low = (-1 * ntohl(end));
		 high = (-1 * ntohl(start));
		 counter = ntohl(start);
		 while (high > low)
		 {
			if((high-low) < max_thread)
			{
				for(loop = low; loop <= high; loop++)
				{				
					bzero(&sin, sizeof(sin));
					sin.sin_addr.s_addr = htonl(counter);      
					sprintf(ipaddress, "%s", inet_ntoa(sin.sin_addr));
					workOrder =
						(threadWorkOrder_t *)malloc(sizeof(threadWorkOrder_t)); 
					sprintf(workOrder->ipaddress, "%s", ipaddress);
					workOrder->output = output;
					pthread_create(&peerVersionQuery[id], NULL,
						(void *) versionquery, (void *) workOrder);
					id++;
					counter++;
				}

        		signal(SIGALRM, timedout);
        		alarm(timeout);

				for(loop = 0; loop <= id; loop++)
				{				
					pthread_join(peerVersionQuery[loop], NULL);
				}
				low = low + max_thread;
				id = 0;
			} else {
				for(loop = low; loop <= (low+max_thread); loop++)
				{
                    bzero(&sin, sizeof(sin));
                    sin.sin_addr.s_addr = htonl(counter);
                    sprintf(ipaddress,"%s", inet_ntoa(sin.sin_addr));
                    workOrder =
                        (threadWorkOrder_t *)malloc(sizeof(threadWorkOrder_t));
                    sprintf(workOrder->ipaddress, "%s", ipaddress);
                    workOrder->output = output;
                    pthread_create(&peerVersionQuery[id], NULL,
                        (void *) versionquery, (void *) workOrder);
					id++;
					counter++;
				}

        		signal(SIGALRM, timedout);
        		alarm(timeout);

                for(loop = 0; loop <= id; loop++)
                {
					pthread_join(peerVersionQuery[loop], NULL);
				}
				low = low + max_thread;
				id = 0;
			}
		 }
  }
  if(list)
  {
     while(fgets(ipaddress,sizeof(ipaddress),input)!=NULL)
     {
         char *token;
         token = strtok(ipaddress, "\n");
         c = 0; 
         while (token !=NULL)
         {
            switch(c)
            {
                case 0:
                sprintf(ipaddress, "%s",token);
                break;
                default:
                break;
            }
            token =strtok(NULL,"\n");
			
			workOrder =
				(threadWorkOrder_t *)malloc(sizeof(threadWorkOrder_t));
			sprintf(workOrder->ipaddress, "%s", ipaddress);
			workOrder->output = output;
			pthread_create(&peerVersionQuery[id], NULL,
				(void *) versionquery, (void *) workOrder);
            c = c +1;
			id++;
			if(id >= max_thread) {
				for(loop = 0; loop <= id; loop++)
				{
					pthread_join(peerVersionQuery[loop], NULL);
				}
				id = 0;
			}
         }
     }
	 if(id != 0)
	 {
		 for(loop = 0; loop <= id; loop++)
		 {
			pthread_join(peerVersionQuery[loop], NULL);
		 }
	 }
  }

  fprintf(stdout,"Done.\n");
  fprintf(output,"Done.\n");
  fclose(output);
  return(0);
}

int versionquery(threadWorkOrder_t *workOrder)
{
    struct sockaddr_in sin;
    struct hostent *host;
    char sendbuff[BUFFSIZE];
    char recvbuff[BUFFSIZE];
    char *line;
	void *ret_val;
    struct in_addr inaddr;
    int sockfd = 0;
    int i  = 0;    
    int iis = 1; 
    char *uri[] ={
    "HEAD / HTTP/1.0\r\nUser-Agent: HTTPDQuery 1.0\r\n\r\n", 
    "GET /x.ida?AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=X HTTP/1.1\r\nHost: CiscoTest\r\n\r\n",
    "GET /scripts/root.exe?/c+dir\r\n\r\n",
    "GET /msadc/root.exe?/c+dir\r\n\r\n",     
    "GET /c/inetpub/scripts/root.exe?/c+dir\r\n\r\n",
    "GET /d/inetpub/scripts/cmd.exe?/c+dir\r\n\r\n"
    };
    struct timeval tv;

	workOrder->id = pthread_self();

    bzero(&sin,sizeof(sin));
    if(inet_pton(AF_INET, workOrder->ipaddress, &inaddr))
       host = gethostbyaddr((char *) &inaddr, sizeof(inaddr), AF_INET);
    else
       host = gethostbyname(workOrder->ipaddress);

    if(host)
       memcpy(&sin.sin_addr, host->h_addr_list[0], sizeof(sin.sin_addr));
    else
    {
      if((inet_addr(workOrder->ipaddress))!=INADDR_NONE)
         sin.sin_addr.s_addr = inet_addr(workOrder->ipaddress);
    }
    for(i=0;i<=5 && (iis==1);i++) 
    {

       if((sockfd = socket(AF_INET,SOCK_STREAM,0)) == -1)
        {
           fprintf(stderr,"Unable to initialize socket.\n");
           return;
        }
        tv.tv_sec  = SNDRCVTIMEOUT;
        tv.tv_usec = SNDRCVTIMEOUT; 
        #if defined (_BSD)
        if(setsockopt(sockfd,SOL_SOCKET,SO_RCVTIMEO,&tv,sizeof(tv))!=0)
           perror("setsockopt");
        if(setsockopt(sockfd,SOL_SOCKET,SO_SNDTIMEO,&tv,sizeof(tv))!=0)
           perror("setsockopt");
        if(setsockopt(sockfd,SOL_SOCKET,SO_RCVLOWAT,(void *) &wait,sizeof(wait))!=0)
           perror("setsockopt");
#endif
        
        sin.sin_family=AF_INET;
        sin.sin_port = htons(80);
        
        if(inet_pton(AF_INET, inet_ntoa(sin.sin_addr), &inaddr)) 
           host = gethostbyaddr((char *)&inaddr, sizeof(inaddr),AF_INET);

        if((connect(sockfd, (struct sockaddr *)&sin, sizeof(sin)) == -1))
        {
           if(errno==EINTR)
              errno=ETIMEDOUT;
			#ifdef VERBOSE
			fprintf(stderr,"%s Closed\n",(char *)inet_ntoa(sin.sin_addr));
			#endif
           close(sockfd);
           return;
        }

		#ifdef VERBOSE
		fprintf(stderr,"%s Open\n",(char *)inet_ntoa(sin.sin_addr));
		#endif
        memset(recvbuff,0,BUFFSIZE);
        memset(sendbuff,0,BUFFSIZE);
        
        sprintf(sendbuff,"%s",uri[i]);
       
        if(send(sockfd,sendbuff,strlen(sendbuff),0) == -1)
        {
           fprintf(stderr, "Error sending request.\n");
           close(sockfd);
           return;
        }
		#ifdef VERBOSE
		else
		fprintf(stderr,"%s",sendbuff);
		#endif
    
        while(recv(sockfd,recvbuff,BUFFSIZE,0)>0)
        {
			#ifdef VERBOSE
			fprintf(stderr,"%s",recvbuff);
			#endif
           
           line = strtok(recvbuff,"\r\n");
           while(line !=NULL)
           {
              if(i == 0) /* Just get Server Version */
              {
                 if(strstr(line,"Server:"))
                 {
                    if(strstr(line,"Microsoft-IIS"))
                      fprintf(stdout,"%s [%s]: %s\n**IIS Code Red Checks**\n",
                             (char *)inet_ntoa(sin.sin_addr),
                             host==NULL ? "unknown" : host->h_name,line);
                    else
                    {
                      iis = 0;
                      fprintf(stdout,"%s [%s]: %s\n**Not Vulnerable**\n",
                             (char *)inet_ntoa(sin.sin_addr),
                             host==NULL ? "unknown" : host->h_name,line);
                    }
                    break;
                 }
              }
              if(i != 0)
              {
                 if(strstr(line,"404 Object Not Found"))
                 {
                    if(i == 1)
                    {
                         fprintf(stderr,"%s [%s] is patched: %s\n",
                                (char *)inet_ntoa(sin.sin_addr),
                                host==NULL ? "unknown" : host->h_name,line);
                         fprintf(workOrder->output,"%s [%s] is patched: %s\n",
                                (char *)inet_ntoa(sin.sin_addr),
                                host==NULL ? "unknown" : host->h_name,line);
                    }
					#ifdef VERBOSE
					fprintf(stderr,"%s %s\n",line,uri[i]);
					#endif 
                    break;
                 } 
                 if(strstr(line,"403 Access Forbidden"))
                 {
					#ifdef VERBOSE
					fprintf(stderr,"%s %s\n",line,uri[i]);
					#endif    
                    break;
                 }

                 if(strstr(line,"0x80040e14"))
                 {
                    fprintf(stderr,"%s [%s] is patched: %s\n",
                    (char *)inet_ntoa(sin.sin_addr),
                    host==NULL ? "unknown" : host->h_name,line);
                    fprintf(workOrder->output,"%s [%s] is patched: %s\n",
                    (char *)inet_ntoa(sin.sin_addr),
                    host==NULL ? "unknown" : host->h_name,line);
                    break;
                 }
                 
                 if(strstr(line,"Error 0xc0000005 caught while processing query"))
                 {
                    fprintf(stderr,"%s [%s] is unpatched: %s\n",      
                    (char *)inet_ntoa(sin.sin_addr),
                    host==NULL ? "unknown" : host->h_name,line);
                    fprintf(workOrder->output,"%s [%s] is unpatched: %s\n",      
                    (char *)inet_ntoa(sin.sin_addr),
                    host==NULL ? "unknown" : host->h_name,line);  
                    break;
                 }
         
                 if(strstr(recvbuff,"Directory of"))
                 {
                    fprintf(stderr,"%s [%s] Compromised Variant 2\n",
                    (char *)inet_ntoa(sin.sin_addr),
                    host==NULL ? "unknown" : host->h_name);
                    fprintf(workOrder->output,"%s [%s] Compromised Variant 2\n",
                    (char *)inet_ntoa(sin.sin_addr),
                    host==NULL ? "unknown" : host->h_name);
                    break;
                 }
              }
              line = strtok(NULL,"\r\n"); 
           }
        }
         
        close(sockfd);
        fflush(workOrder->output); 
		#ifdef VERBOSE
		fprintf(stderr,"Closing %s\n",(char *)inet_ntoa(sin.sin_addr));
		#endif
    }  /* While Checking uri  */
    return(0);  
}

void timedout(int signo)
{
	int loop = 0;

	signal(SIGALRM, timedout);

	#ifdef VERBOSE
	fprintf(stderr,"Connection timed out.  Killing %d threads.\n", id);
	#endif

	for(loop = 0; loop <= id; loop++)
	{				
		pthread_detach(peerVersionQuery[loop]);
		#ifdef VERBOSE
		fprintf(stderr, "SIGKILL sent to thread %d, returned %d\n",
			id, ret_val);
		#endif
	}
	return;
}

void usage()
{
   fprintf(stderr,"coderescan.c v2.4 08/11/2001 Kirby Kuehl kkuehl@cisco.com and Rob Thomas robt@cymru.com\n\n");
   fprintf(stderr,"Usage: coderedscan -h <single host ip> || -s <starting ip> -e <ending ip> || -l <ip list> || -t <maximum threads> || -c <timeout in seconds>\n");
   exit(-1);
}

