/*
** Copyright (C) 1998,1999,2000 Martin Roesch <roesch@clark.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "spp_minfrag.h"


void SetupMinfrag()
{
   RegisterPreprocessor("minfrag", MinfragInit);

#ifdef DEBUG
   printf("Preprocessor: Minfrag Initialized\n");
#endif
}


void MinfragInit(u_char *args)
{
#ifdef DEBUG
   printf("Preprocessor: Minfrag initializing\n");
#endif

   while(isspace(*args)) args++;

   minfrag = atoi(args);

#ifdef DEBUG
   printf("Setting Minimum Fragment Size: %d bytes\n", minfrag);
#endif

   AddFuncToPreprocList(CheckMinfrag);
}



void CheckMinfrag(Packet *p)
{
   if(!p->frag_flag)
   {
#ifdef DEBUG
      printf("p->frag_flag = %d\n", p->frag_flag);
#endif
      return;
   }

#ifdef DEBUG
   printf("p->frag_offset = 0x%04X\n", p->frag_offset);
#endif

   if(p->frag_offset == 0)
   {
      if(p->dsize <= minfrag)
      {
#ifdef DEBUG
         printf("datasize = %d   minfrag = %d  \n", p->dsize, minfrag);
         printf("Calling AlertFunc & LogFunc!\n");
#endif
         (*AlertFunc)(p, MINFRAG_ALERT_MESSAGE);
         (*LogFunc)(p);
      }
   }
}


