#!/usr/bin/perl
#
# WSH configuration script
#
# This file is part of WebShell which is distributed under the terms of the GNU
# General Public License v2.0
#
# VERSION 2.0.1

use strict;
use File::Copy;

my %CONF;
$CONF{KEY} = "KEY";
$CONF{INVERT} = 85;

my $f_config = "wsh-c.conf";
my $f_client = "wsh-c.pl";
my $f_client_http = "wsh-c-HTTP.pl";
my $f_client_ssl  = "wsh-c-SSL.pl";
my $f_server = "wsh-s.pl";

print qq~
 -- WSH configuration script --

Use WSH client with SSL support?
(Net::SSLeay module is required)
~;
$CONF{SSL} = yesorno();
print qq~
Enter <Key> value or press [enter] for default: '$CONF{KEY}'
(letters, numbers, no spaces): ~;
my $input = <STDIN>;
chomp($input);
$CONF{KEY} = $input
	if ($input !~ /^\s*$/s);
die "Invalid <Key> value - '$CONF{KEY}'!\n"
	unless ($CONF{KEY} =~ /^[a-z0-9]+$/is);
print "\nDo you want to encode data flow with Xor?\n";
print "(no reason in Xor encoding if you are using SSL)\n";
$CONF{ENCODE} = yesorno();
if ($CONF{ENCODE}) {
	print "\nEnter <Xor byte> value or press [enter] for ".
		"default: '$CONF{INVERT}'\n(1..255): ";
	my $input = <STDIN>;
	chomp($input);
	$CONF{INVERT} = $input
		if ($input !~ /^\s*$/s);
	die "Invalid <Xor byte> value - $CONF{INVERT}!\n"
		if ($CONF{INVERT} < 1 || $CONF{INVERT} > 255);
}
print "\nIs target host running under Win32?\n";
$CONF{WIN} = yesorno();

# ssl ----------------------------------
if ($CONF{SSL}) {
	copy($f_client_ssl, $f_client);
} else {
	copy($f_client_http, $f_client);
}
# win ----------------------------------
replace($f_config,
	'win32\s+\d+',
	"win32\t\t$CONF{WIN}");
replace($f_server,
	'my \$win = [^;]+',
	"my \$win = $CONF{WIN}");

# encode -------------------------------
replace($f_config,
	'encode\s+\d+',
	"encode\t\t$CONF{ENCODE}");
replace($f_server,
	'my \$enc = [^;]+',
	"my \$enc = $CONF{ENCODE}");
replace($f_config,
	'invert\s+\d+',
	"invert\t\t$CONF{INVERT}")
	if ($CONF{ENCODE});
replace($f_server,
	'my \$invert = [^;]+',
	"my \$invert = $CONF{INVERT}")
	if ($CONF{ENCODE});

# key ----------------------------------
replace($f_server,
	'\$ENV{HTTP_X_KEY} eq \"[^"]+\"',
	"\$ENV{HTTP_X_KEY} eq \"$CONF{KEY}\"");
print qq~
 -- done --

Please, check "INSTALLATION" section in the file README

~;

sub replace(@) {
	my $file = $_[0]; 
	my $replace = $_[1];
	my $with = $_[2];
	open(F, $file)
		or die "Fail to read file $file: $!\n";
	read(F, my $buf, -s $file);
	close(F);
	$buf =~ s/$replace/$with/;
	open(F, "> $file")
		or die "Fail to write file $file: $!\n";
	print F $buf;
	close(F);
	return;
}

sub yesorno(@) {
	my $input;
	while ($input ne "y" && $input ne "n") {
		print "(y/n): ";
		$input = <STDIN>;
		chomp($input);
	}
	return ($input eq "y") ? 1 : 0;
}
